/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.shared.debug.Debug;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.forgerock.util.thread.listener.ShutdownListener;
import org.forgerock.util.thread.listener.ShutdownPriority;

public final class ShutdownManager
implements org.forgerock.util.thread.listener.ShutdownManager {
    private static volatile ShutdownManager instance;
    protected Set<ShutdownListener>[] listeners;
    protected volatile boolean shutdownCalled = false;
    private volatile ShutdownListener appSSOTokenDestroyer;
    private static ReentrantReadWriteLock rwlock;

    private ShutdownManager() {
        int size = ShutdownPriority.HIGHEST.getIntValue();
        this.listeners = new HashSet[size];
        for (int i = 0; i < size; ++i) {
            this.listeners[i] = new HashSet<ShutdownListener>();
        }
        boolean hooksEnabled = Boolean.valueOf(System.getProperty("openam.runtime.shutdown.hook.enabled"));
        if (hooksEnabled) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    ShutdownManager.this.shutdown();
                }
            }, "ShutdownThread"));
        }
    }

    private boolean acquireValidLock() {
        if (this.shutdownCalled) {
            return false;
        }
        rwlock.writeLock().lock();
        return true;
    }

    private void releaseLockAndNotify() throws IllegalMonitorStateException {
        rwlock.writeLock().unlock();
    }

    public static synchronized ShutdownManager getInstance() {
        if (instance == null) {
            instance = new ShutdownManager();
        }
        return instance;
    }

    public void addShutdownListener(ShutdownListener listener) throws IllegalMonitorStateException {
        this.addShutdownListener(listener, ShutdownPriority.DEFAULT);
    }

    public void addShutdownListener(ShutdownListener listener, ShutdownPriority priority) throws IllegalMonitorStateException {
        if (this.acquireValidLock()) {
            try {
                this.removeShutdownListener(listener);
                this.listeners[priority.getIntValue() - 1].add(listener);
            }
            finally {
                this.releaseLockAndNotify();
            }
        } else {
            throw new IllegalMonitorStateException("Failed to acquire lock registering the ShutdownListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceShutdownListener(ShutdownListener oldListener, ShutdownListener newListener, ShutdownPriority priority) {
        if (this.acquireValidLock()) {
            try {
                this.removeShutdownListener(oldListener);
                if (priority == null) {
                    this.addShutdownListener(newListener);
                }
                this.addShutdownListener(newListener, priority);
            }
            finally {
                this.releaseLockAndNotify();
            }
        } else {
            throw new IllegalMonitorStateException("Failed to acquire lock replacing the ShutdownListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownListener(ShutdownListener listener) throws IllegalMonitorStateException {
        if (this.acquireValidLock()) {
            try {
                List priorities = ShutdownPriority.getPriorities();
                for (ShutdownPriority priority : priorities) {
                    int index = priority.getIntValue();
                    if (!this.listeners[index - 1].remove(listener)) continue;
                }
            }
            finally {
                this.releaseLockAndNotify();
            }
        } else {
            throw new IllegalMonitorStateException("Failed to acquire lock unregistering with ShutdownListener");
        }
    }

    public void shutdown() throws IllegalMonitorStateException {
        if (this.acquireValidLock()) {
            try {
                this.shutdownCalled = true;
                List priorities = ShutdownPriority.getPriorities();
                for (ShutdownPriority i : priorities) {
                    Iterator<ShutdownListener> j = this.listeners[i.getIntValue() - 1].iterator();
                    while (j.hasNext()) {
                        j.next().shutdown();
                        j.remove();
                    }
                }
                if (this.appSSOTokenDestroyer != null) {
                    this.appSSOTokenDestroyer.shutdown();
                    this.appSSOTokenDestroyer = null;
                }
                instance = null;
            }
            catch (RuntimeException t) {
                Debug.getInstance("amUtil").error("Error during shutdown", t);
                throw t;
            }
            finally {
                this.releaseLockAndNotify();
            }
        } else {
            throw new IllegalMonitorStateException("Failed to acquire lock during shutdown.");
        }
    }

    public void addApplicationSSOTokenDestroyer(ShutdownListener listener) {
        this.appSSOTokenDestroyer = listener;
    }

    static {
        rwlock = new ReentrantReadWriteLock();
    }
}

