/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.protocol.AMURLStreamHandlerFactory;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpURLConnectionManager {
    private static Debug debug = Debug.getInstance("PLLClient");
    private static int READ_TIMEOUT = 3000;
    private static int CONNECT_TIMEOUT = 1500;
    private static final String URL_READ_TIMEOUT = "com.sun.identity.url.readTimeout";
    private static final String URL_CONNECT_TIMEOUT = "org.forgerock.openam.url.connectTimeout";
    private static String prot_handler_string = null;
    private static AMURLStreamHandlerFactory stFactory = new AMURLStreamHandlerFactory();

    private static void initialize() {
        String cto;
        String rto;
        prot_handler_string = SystemPropertiesManager.get("opensso.protocol.handler.pkgs", null);
        if (debug.messageEnabled()) {
            debug.message("Configured Protocol Handler : " + prot_handler_string);
        }
        if ((rto = SystemPropertiesManager.get(URL_READ_TIMEOUT)) != null && rto.length() > 0) {
            try {
                READ_TIMEOUT = Integer.valueOf(rto);
                if (debug.messageEnabled()) {
                    debug.message("HttpURLConnectionManager.initialize(): Set READTIMEOUT to " + READ_TIMEOUT);
                }
            }
            catch (Exception e) {
                debug.error("HttpURLConnectionManager.initialize(): Fail to read com.sun.identity.url.readTimeout using default READTIMEOUT " + READ_TIMEOUT, e);
            }
        }
        if ((cto = SystemPropertiesManager.get(URL_CONNECT_TIMEOUT)) != null && cto.length() > 0) {
            try {
                CONNECT_TIMEOUT = Integer.valueOf(cto);
                if (debug.messageEnabled()) {
                    debug.message("HttpURLConnectionManager.initialize(): Set CONNECT_TIMEOUT to " + CONNECT_TIMEOUT);
                }
            }
            catch (Exception ex) {
                debug.error("HttpURLConnectionManager.initialize(): Fail to read org.forgerock.openam.url.connectTimeout using default CONNECT_TIMEOUT " + CONNECT_TIMEOUT, ex);
            }
        }
    }

    public static HttpURLConnection getConnection(URL url) throws IOException {
        String prot = url.getProtocol();
        if (prot_handler_string != null && prot.equalsIgnoreCase("https")) {
            url = new URL(url, url.toExternalForm(), stFactory.createURLStreamHandler("https"));
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(READ_TIMEOUT);
        conn.setConnectTimeout(CONNECT_TIMEOUT);
        return conn;
    }

    public static int getReadTimeout() {
        return READ_TIMEOUT;
    }

    public static int getConnectTimeout() {
        return CONNECT_TIMEOUT;
    }

    static {
        HttpURLConnectionManager.initialize();
    }
}

