/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.CaseInsensitiveKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class CaseInsensitiveHashSet<T>
extends HashSet<T> {
    public CaseInsensitiveHashSet() {
    }

    public CaseInsensitiveHashSet(Collection c) {
        super(c);
    }

    public CaseInsensitiveHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public CaseInsensitiveHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    public boolean add(T o) {
        boolean retval;
        if (o instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)o);
            retval = super.add(ciKey);
        } else {
            retval = super.add(o);
        }
        return retval;
    }

    @Override
    public boolean contains(Object o) {
        boolean retval = o instanceof String ? super.contains(new CaseInsensitiveKey((String)o)) : super.contains(o);
        return retval;
    }

    @Override
    public boolean remove(Object o) {
        boolean retval = o instanceof String ? super.remove(new CaseInsensitiveKey((String)o)) : super.remove(o);
        return retval;
    }

    @Override
    public Iterator<T> iterator() {
        return new CaseInsensitiveKeyIterator(super.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c instanceof CaseInsensitiveHashSet) {
            return super.removeAll(c);
        }
        CaseInsensitiveHashSet<T> ciHashSet = new CaseInsensitiveHashSet<T>(c);
        return super.removeAll(ciHashSet);
    }

    @Override
    public Object[] toArray(Object[] a) {
        Object[] ret = null;
        Object[] arr = super.toArray();
        ret = a != null && a.length >= arr.length ? a : new Object[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = arr[i] instanceof CaseInsensitiveKey ? ((CaseInsensitiveKey)arr[i]).toString() : arr[i];
        }
        if (a != null && ret == a && a.length > arr.length) {
            ret[arr.length] = null;
        }
        return ret;
    }

    private static class CaseInsensitiveKeyIterator<T>
    implements Iterator<T> {
        Iterator<T> mIterator;

        public CaseInsensitiveKeyIterator(Iterator<T> iterator) {
            this.mIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public T next() {
            T nextIter = this.mIterator.next();
            if (nextIter instanceof CaseInsensitiveKey) {
                return (T)((CaseInsensitiveKey)nextIter).toString();
            }
            return nextIter;
        }

        @Override
        public void remove() {
            this.mIterator.remove();
        }
    }
}

