/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.common.CaseInsensitiveKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveHashMap<K, V>
extends HashMap<K, V> {
    public CaseInsensitiveHashMap() {
    }

    public CaseInsensitiveHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CaseInsensitiveHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveHashMap(Map t) {
        this.putAll(t);
    }

    @Override
    public boolean containsKey(Object key) {
        boolean retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.containsKey(ciKey);
        } else {
            retval = super.containsKey(key);
        }
        return retval;
    }

    @Override
    public V get(Object key) {
        Object retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.get(ciKey);
        } else {
            retval = super.get(key);
        }
        return retval;
    }

    @Override
    public Set<K> keySet() {
        return new CaseInsensitiveHashSet((Collection)super.keySet());
    }

    @Override
    public Set entrySet() {
        Set entries = super.entrySet();
        HashSet<Entry> set = new HashSet<Entry>();
        for (Map.Entry entry : entries) {
            set.add(new Entry(entry));
        }
        return set;
    }

    @Override
    public V put(K key, V value) {
        V retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.put(ciKey, value);
        } else {
            retval = super.put(key, value);
        }
        return retval;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Object retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.remove(ciKey);
        } else {
            retval = super.remove(key);
        }
        return retval;
    }

    private static class Entry
    implements Map.Entry {
        Map.Entry entry;

        Entry(Map.Entry entry) {
            this.entry = entry;
        }

        public Object getKey() {
            return this.entry.getKey().toString();
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        @Override
        public boolean equals(Object o) {
            return this.entry.equals(o);
        }

        public Object setValue(Object o) {
            return this.entry.setValue(o);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }
    }
}

