/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.ConfigurableKey;
import com.sun.identity.shared.debug.Debug;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.forgerock.openam.utils.CipherProvider;
import org.forgerock.openam.utils.Providers;

public class JCEEncryption
implements AMEncryption,
ConfigurableKey {
    private static final byte VERSION = 1;
    private static final String CRYPTO_DESCRIPTOR = System.getProperty("amCryptoDescriptor", "PBEWithMD5AndDES");
    private static final String CRYPTO_DESCRIPTOR_PROPERTY_NAME = "amCryptoDescriptor";
    private static final String CRYPTO_DESCRIPTOR_DEFAULT_VALUE = "PBEWithMD5AndDES";
    private static final String CRYPTO_DESCRIPTOR_PROVIDER;
    private static final String CRYPTO_DESCRIPTOR_PROVIDER_PROPERTY_NAME = "amCryptoDescriptor.provider";
    private static final String CRYPTO_DESCRIPTOR_PROVIDER_DEFAULT_VALUE = "SunJCE";
    private static final String KEYGEN_ALGORITHM;
    private static final String KEYGEN_ALGORITHM_PROPERTY_NAME = "amKeyGenDescriptor";
    private static final String KEYGEN_ALGORITHM_DEFAULT_VALUE = "PBEWithMD5AndDES";
    private static final String KEYGEN_ALGORITHM_PROVIDER;
    private static final String KEYGEN_ALGORITHM_PROVIDER_PROPERTY_NAME = "amKeyGenDescriptor.provider";
    private static final String KEYGEN_ALGORITHM_PROVIDER_DEFAULT_VALUE = "SunJCE";
    private static final int DEFAULT_KEYGEN_ALG_INDEX = 2;
    private static final int DEFAULT_ENC_ALG_INDEX = 2;
    private static final int ITERATION_COUNT = 5;
    private static final String CRYPTO_CACHE_SIZE_PROPERTY_NAME = "amCryptoCacheSize";
    private static final int DEFAULT_CACHE_SIZE = 500;
    private static final int CACHE_SIZE;
    private static final CipherProvider cipherProvider;
    private static final byte[] ___y;
    private volatile SecretKey pbeKey;
    private volatile boolean _initialized = false;
    private static final PBEParameterSpec pbeParameterSpec;

    @Override
    public byte[] encrypt(byte[] clearText) {
        return this.pbeEncrypt(clearText);
    }

    @Override
    public byte[] decrypt(byte[] encText) {
        return this.pbeDecrypt(encText);
    }

    private byte[] pbeEncrypt(byte[] clearText) {
        byte[] result;
        block9: {
            result = null;
            if (clearText == null || clearText.length == 0) {
                return null;
            }
            if (this._initialized) {
                try {
                    byte[] type = new byte[2];
                    type[1] = 2;
                    type[0] = 2;
                    Cipher pbeCipher = cipherProvider.getCipher();
                    if (pbeCipher != null) {
                        pbeCipher.init(1, (Key)this.pbeKey, pbeParameterSpec);
                        result = pbeCipher.doFinal(clearText);
                        byte[] iv = pbeCipher.getIV();
                        result = JCEEncryption.addPrefix(type, iv, result);
                    } else {
                        Debug debug = Debug.getInstance("amSDK");
                        if (debug != null) {
                            debug.error("JCEEncryption: Failed to obtain Cipher");
                        }
                    }
                    break block9;
                }
                catch (Exception ex) {
                    Debug debug = Debug.getInstance("amSDK");
                    if (debug != null) {
                        debug.error("JCEEncryption:: failed to encrypt data", ex);
                    }
                    break block9;
                }
            }
            Debug debug = Debug.getInstance("amSDK");
            if (debug != null) {
                debug.error("JCEEncryption:: not yet initialized");
            }
        }
        return result;
    }

    private static byte[] addPrefix(byte[] type, byte[] iv, byte[] share) {
        int i;
        byte[] data = new byte[share.length + 11];
        data[0] = 1;
        data[1] = type[0];
        data[2] = type[1];
        for (i = 0; i < 8; ++i) {
            data[3 + i] = iv[i];
        }
        for (i = 0; i < share.length; ++i) {
            data[11 + i] = share[i];
        }
        return data;
    }

    private byte[] pbeDecrypt(byte[] cipherText) {
        byte[] result;
        block10: {
            result = null;
            if (this._initialized) {
                try {
                    byte[] share = cipherText;
                    if (share[0] != 1) {
                        Debug debug = Debug.getInstance("amSDK");
                        if (debug != null) {
                            debug.message("JCEEncryption:: Unsupported version: " + share[0]);
                        }
                        return null;
                    }
                    byte[] raw = JCEEncryption.getRaw(share);
                    Cipher pbeCipher = cipherProvider.getCipher();
                    if (pbeCipher != null) {
                        pbeCipher.init(2, (Key)this.pbeKey, pbeParameterSpec);
                        result = pbeCipher.doFinal(raw);
                    } else {
                        Debug debug = Debug.getInstance("amSDK");
                        if (debug != null) {
                            debug.error("JCEEncryption: Failed to obtain Cipher");
                        }
                    }
                    break block10;
                }
                catch (Exception ex) {
                    Debug debug = Debug.getInstance("amSDK");
                    if (debug != null) {
                        debug.error("JCEEncryption:: failed to decrypt data", ex);
                    }
                    break block10;
                }
            }
            Debug debug = Debug.getInstance("amSDK");
            if (debug != null) {
                debug.error("JCEEncryption:: not yet initialized");
            }
        }
        return result;
    }

    private static byte[] getRaw(byte[] share) {
        byte[] data = new byte[share.length - 11];
        for (int i = 11; i < share.length; ++i) {
            data[i - 11] = share[i];
        }
        return data;
    }

    @Override
    public void setPassword(String password) throws Exception {
        this.pbeKey = SecretKeyFactory.getInstance(KEYGEN_ALGORITHM, KEYGEN_ALGORITHM_PROVIDER).generateSecret(new PBEKeySpec(password.toCharArray()));
        this._initialized = true;
    }

    static {
        KEYGEN_ALGORITHM = System.getProperty(KEYGEN_ALGORITHM_PROPERTY_NAME, "PBEWithMD5AndDES");
        CRYPTO_DESCRIPTOR_PROVIDER = System.getProperty(CRYPTO_DESCRIPTOR_PROVIDER_PROPERTY_NAME, "SunJCE");
        KEYGEN_ALGORITHM_PROVIDER = System.getProperty(KEYGEN_ALGORITHM_PROVIDER_PROPERTY_NAME, "SunJCE");
        CACHE_SIZE = Integer.getInteger(CRYPTO_CACHE_SIZE_PROPERTY_NAME, 500);
        cipherProvider = Providers.cipherProvider(CRYPTO_DESCRIPTOR, CRYPTO_DESCRIPTOR_PROVIDER, CACHE_SIZE);
        ___y = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
        pbeParameterSpec = new PBEParameterSpec(___y, 5);
    }
}

