/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.ConfigurableKey;
import com.iplanet.services.util.JCEEncryption;
import com.sun.identity.security.ISSecurityPermission;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

public class Crypt {
    private static final String ENCRYPTOR_CLASS_PROPERTY = "com.iplanet.security.encryptor";
    private static final String CHECK_CALLER_PROPERTY = "com.sun.identity.security.checkcaller";
    private static final String DEFAULT_ENCRYPTOR_CLASS = "com.iplanet.services.util.JCEEncryption";
    private static final String PROPERTY_PWD = "am.encryption.pwd";
    private static final String PROPERTY_PWD_LOCAL = "com.sun.identity.client.encryptionKey";
    private static final String DEFAULT_PWD = "KmhUnWR1MYWDYW4xuqdF5nbm+CXIyOVt";
    private static boolean checkCaller;
    public static SecurityManager securityManager;
    private static AMEncryption encryptor;
    private static AMEncryption localEncryptor;
    private static AMEncryption hardcodedKeyEncryptor;
    private static final String[] VALID_PACKAGES;
    private static final String[] VALID_CLASSES;
    private static final String CLASSNAME = "com.iplanet.services.util.Crypt";
    private static final String AT_NAME = "at ";

    public static synchronized void reinitialize() {
        Crypt.initialize();
    }

    private static void initialize() {
        encryptor = Crypt.createInstance(SystemPropertiesManager.get(PROPERTY_PWD, DEFAULT_PWD));
        localEncryptor = Crypt.createInstance(SystemPropertiesManager.get(PROPERTY_PWD_LOCAL, SystemPropertiesManager.get(PROPERTY_PWD, DEFAULT_PWD)));
        hardcodedKeyEncryptor = Crypt.createInstance(DEFAULT_PWD);
        String cCaller = SystemPropertiesManager.get(CHECK_CALLER_PROPERTY);
        if (cCaller != null && cCaller.equalsIgnoreCase("true")) {
            checkCaller = true;
            securityManager = System.getSecurityManager();
        }
    }

    private static AMEncryption createInstance(String password) {
        AMEncryption instance;
        block4: {
            Debug debug;
            String encClass = SystemPropertiesManager.get(ENCRYPTOR_CLASS_PROPERTY, DEFAULT_ENCRYPTOR_CLASS);
            try {
                instance = (AMEncryption)Class.forName(encClass).newInstance();
            }
            catch (Exception e) {
                debug = Debug.getInstance("amSDK");
                debug.error("Crypt:: Unable to get class instance: " + encClass, e);
                instance = new JCEEncryption();
            }
            try {
                ((ConfigurableKey)((Object)instance)).setPassword(password);
            }
            catch (Exception e) {
                debug = Debug.getInstance("amSDK");
                if (debug == null) break block4;
                debug.error("Crypt: failed to set password-based key", e);
            }
        }
        return instance;
    }

    public static boolean checkCaller() {
        return checkCaller;
    }

    public static AMEncryption getHardcodedKeyEncryptor() {
        return hardcodedKeyEncryptor;
    }

    private static boolean isAccessPermitted() {
        try {
            ISSecurityPermission isp = new ISSecurityPermission("access", "adminpassword");
            if (securityManager != null) {
                securityManager.checkPermission(isp);
            }
            return true;
        }
        catch (SecurityException e) {
            Debug debug = Debug.getInstance("amSDK");
            debug.error("Security Alert: Unauthorized access to Encoding/Decoding password utility: Returning NULL", e);
            return false;
        }
    }

    public static AMEncryption getEncryptor() {
        return Crypt.isAccessPermitted() ? encryptor : null;
    }

    public static String encrypt(String clearText) {
        return Crypt.encode(clearText);
    }

    public static String encryptLocal(String clearText) {
        return Crypt.encode(clearText, localEncryptor);
    }

    public static String decrypt(String encoded) {
        return Crypt.decode(encoded);
    }

    public static String decryptLocal(String encoded) {
        return Crypt.decode(encoded, localEncryptor);
    }

    public static String encode(String clearText, AMEncryption encr) {
        if (Crypt.checkCaller() && !Crypt.isAccessPermitted()) {
            return null;
        }
        if (clearText == null || clearText.length() == 0) {
            return null;
        }
        byte[] encData = null;
        try {
            encData = encr.encrypt(clearText.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException uee) {
            Debug debug = Debug.getInstance("amSDK");
            debug.error("Crypt:: utf-8 encoding is not supported");
            encData = encryptor.encrypt(clearText.getBytes());
        }
        String str = null;
        str = Base64.encode(encData).trim();
        BufferedReader bufReader = new BufferedReader(new StringReader(str));
        StringBuffer strClean = new StringBuffer(str.length());
        String strTemp = null;
        try {
            while ((strTemp = bufReader.readLine()) != null) {
                strClean.append(strTemp);
            }
        }
        catch (IOException ioe) {
            Debug debug = Debug.getInstance("amSDK");
            debug.error("Crypt:: Error while base64 encoding", ioe);
        }
        return strClean.toString();
    }

    public static String encode(String clearText) {
        return Crypt.encode(clearText, encryptor);
    }

    public static String decode(String encoded, AMEncryption encr) {
        if (Crypt.checkCaller()) {
            try {
                ISSecurityPermission isp = new ISSecurityPermission("access", "adminpassword");
                if (securityManager != null) {
                    securityManager.checkPermission(isp);
                }
            }
            catch (SecurityException e) {
                Debug debug = Debug.getInstance("amSDK");
                debug.error("Security Alert: Unauthorized access to Encoding/Decoding password utility: Returning NULL", e);
                return null;
            }
        }
        if (encoded == null || encoded.length() == 0) {
            return null;
        }
        byte[] encData = null;
        encData = Base64.decode(encoded.trim());
        if (encData == null) {
            return null;
        }
        byte[] rawData = encr.decrypt(encData);
        if (rawData == null) {
            return null;
        }
        String answer = null;
        try {
            answer = new String(rawData, "utf-8");
        }
        catch (UnsupportedEncodingException uue) {
            Debug debug = Debug.getInstance("amSDK");
            debug.error("Crypt:: Unsupported encoding UTF-8", uue);
            answer = new String(rawData);
        }
        return answer;
    }

    public static String decode(String encoded) {
        return Crypt.decode(encoded, encryptor);
    }

    protected static boolean isCallerValid() {
        if (!checkCaller) {
            return true;
        }
        return Crypt.isCallerValid(CLASSNAME);
    }

    public static boolean isCallerValid(Object obj) {
        if (!checkCaller) {
            return true;
        }
        if (obj == null) {
            return Crypt.isCallerValid(CLASSNAME);
        }
        return Crypt.isCallerValid(obj.getClass().getName());
    }

    public static boolean isCallerValid(String className) {
        int i;
        if (!checkCaller) {
            return true;
        }
        String parentClass = Crypt.getParentClass(className);
        for (i = 0; i < VALID_PACKAGES.length; ++i) {
            if (!parentClass.startsWith(VALID_PACKAGES[i])) continue;
            return true;
        }
        for (i = 0; i < VALID_CLASSES.length; ++i) {
            if (!parentClass.equals(VALID_CLASSES[i])) continue;
            return true;
        }
        return false;
    }

    protected static String getParentClass(String callerClass) {
        String parentClass = null;
        try {
            throw new Exception();
        }
        catch (Exception pe) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(os);
            pe.printStackTrace(ps);
            String stackTrace = os.toString();
            String index = stackTrace.substring(stackTrace.lastIndexOf(callerClass) + callerClass.length());
            stackTrace = index.substring(index.lastIndexOf(AT_NAME) + AT_NAME.length());
            parentClass = stackTrace.substring(0, stackTrace.indexOf("("));
            parentClass = stackTrace.substring(0, parentClass.lastIndexOf("."));
            return parentClass;
        }
    }

    static {
        Crypt.initialize();
        VALID_PACKAGES = new String[]{"com.iplanet.services", "com.iplanet.am", "com.sun.identity.policy"};
        VALID_CLASSES = new String[]{CLASSNAME, "TestCrypt"};
    }
}

