/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import sun.security.util.BitArray;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AVA;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.RDN;

public class IssuingDistributionPointExtension
extends Extension {
    public static final String IDENT = "x509.info.extensions.IssuingDistributionPoint";
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFILIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    private static final String[] REASON_STRINGS = new String[]{null, "key compromise", "CA compromise", "affiliation changed", "superseded", "cessation of operation", "certificate hold"};
    public static final String NAME = "IssuingDistributionPoint";
    private static final byte TAG_DIST_PT = 0;
    private static final byte TAG_ONLY_USER_CERTS = 1;
    private static final byte TAG_ONLY_CA_CERTS = 2;
    private static final byte TAG_REASONS = 3;
    private static final byte TAG_INDIRECT_CRL = 4;
    private static final byte TAG_FULL_NAME = 0;
    private static final byte TAG_REL_NAME = 1;
    private GeneralNames fullName = null;
    private RDN relativeName = null;
    private boolean onlyContainsUserCerts = false;
    private boolean onlyContainsCACerts = false;
    private boolean[] reasonFlags = null;
    private boolean indirectCRL = false;
    private volatile int hashCode;

    public IssuingDistributionPointExtension(GeneralNames fullName, boolean onlyContainsUserCerts, boolean onlyContainsCACerts, boolean[] reasonFlags, boolean indirectCRL, boolean critical) throws IOException {
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = critical;
        this.fullName = fullName;
        this.onlyContainsUserCerts = onlyContainsUserCerts;
        this.onlyContainsCACerts = onlyContainsCACerts;
        this.reasonFlags = reasonFlags;
        this.indirectCRL = indirectCRL;
        this.encodeThis();
    }

    public IssuingDistributionPointExtension(RDN relativeName, boolean onlyContainsUserCerts, boolean onlyContainsCACerts, boolean[] reasonFlags, boolean indirectCRL, boolean critical) throws IOException {
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = critical;
        this.relativeName = relativeName;
        this.onlyContainsUserCerts = onlyContainsUserCerts;
        this.onlyContainsCACerts = onlyContainsCACerts;
        this.reasonFlags = reasonFlags;
        this.indirectCRL = indirectCRL;
        this.encodeThis();
    }

    public IssuingDistributionPointExtension(Object value) throws IOException {
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = true;
        if (!(value instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for IssuingDistributionPointExtension.");
        }
        if (val.data == null || val.data.available() == 0) {
            return;
        }
        DerValue opt = val.data.getDerValue();
        if (opt.isContextSpecific((byte)0) && opt.isConstructed()) {
            DerValue distPnt = opt.data.getDerValue();
            if (distPnt.isContextSpecific((byte)0) && distPnt.isConstructed()) {
                distPnt.resetTag((byte)48);
                this.fullName = new GeneralNames(distPnt);
            } else if (distPnt.isContextSpecific((byte)1) && distPnt.isConstructed()) {
                distPnt.resetTag((byte)49);
                this.relativeName = new RDN(IssuingDistributionPointExtension.derValueToAVAs(distPnt));
            } else {
                throw new IOException("Invalid encoding for IssuingDistributionPointExtension.");
            }
            if (val.data.available() == 0) {
                return;
            }
            opt = val.data.getDerValue();
        }
        if (opt.isContextSpecific((byte)1)) {
            opt.resetTag((byte)1);
            this.onlyContainsUserCerts = opt.getBoolean();
            if (val.data.available() == 0) {
                return;
            }
            opt = val.data.getDerValue();
        }
        if (opt.isContextSpecific((byte)2)) {
            opt.resetTag((byte)1);
            this.onlyContainsCACerts = opt.getBoolean();
            if (this.onlyContainsUserCerts && this.onlyContainsCACerts) {
                throw new IOException("onlyContainsUserCerts and onlyContainsCACerts can't both be true");
            }
            if (val.data.available() == 0) {
                return;
            }
            opt = val.data.getDerValue();
        }
        if (opt.isContextSpecific((byte)3) && !opt.isConstructed()) {
            opt.resetTag((byte)3);
            this.reasonFlags = opt.getUnalignedBitString().toBooleanArray();
            if (val.data.available() == 0) {
                return;
            }
            opt = val.data.getDerValue();
        }
        if (opt.isContextSpecific((byte)4)) {
            opt.resetTag((byte)1);
            this.indirectCRL = opt.getBoolean();
            if (val.data.available() == 0) {
                return;
            }
        }
        throw new IOException("Invalid encoding for IssuingDistributionPointExtension.");
    }

    @Override
    public String getName() {
        return NAME;
    }

    public GeneralNames getFullName() {
        return this.fullName;
    }

    public RDN getRelativeName() {
        return this.relativeName;
    }

    public boolean getOnlyContainsUserCerts() {
        return this.onlyContainsUserCerts;
    }

    public boolean getOnlyContainsCACerts() {
        return this.onlyContainsCACerts;
    }

    public boolean[] getOnlySomeReasons() {
        return this.reasonFlags;
    }

    public boolean getIndirectCRL() {
        return this.indirectCRL;
    }

    public void setFullName(GeneralNames fullName) {
        this.fullName = fullName;
        if (fullName != null) {
            this.relativeName = null;
        }
    }

    public void setRelativeName(RDN relativeName) {
        this.relativeName = relativeName;
        if (relativeName != null) {
            this.fullName = null;
        }
    }

    public void setOnlyContainsUserCerts(boolean onlyContainsUserCerts) {
        this.onlyContainsUserCerts = onlyContainsUserCerts;
    }

    public void setOnlyContainsCACerts(boolean onlyContainsCACerts) {
        this.onlyContainsCACerts = onlyContainsCACerts;
    }

    public void setOnlySomeReasons(boolean[] reasonFlags) {
        this.reasonFlags = reasonFlags;
    }

    public void setIndirectCRL(boolean indirectCRL) {
        this.indirectCRL = indirectCRL;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    private void encodeThis() throws IOException {
        if (this.onlyContainsUserCerts && this.onlyContainsCACerts) {
            throw new IOException("onlyContainsUserCerts and onlyContainsCACerts can't both be true");
        }
        DerOutputStream tagged = new DerOutputStream();
        if (this.fullName != null || this.relativeName != null) {
            DerOutputStream derOut;
            DerOutputStream distributionPoint = new DerOutputStream();
            if (this.fullName != null) {
                derOut = new DerOutputStream();
                this.fullName.encode(derOut);
                distributionPoint.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOut);
            } else if (this.relativeName != null) {
                derOut = new DerOutputStream();
                IssuingDistributionPointExtension.encodeRDN(this.relativeName, derOut);
                distributionPoint.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOut);
            }
            tagged.write(DerValue.createTag((byte)-128, true, (byte)0), distributionPoint);
        }
        if (this.onlyContainsUserCerts) {
            DerOutputStream doOnlyContainsUserCerts = new DerOutputStream();
            doOnlyContainsUserCerts.putBoolean(this.onlyContainsUserCerts);
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), doOnlyContainsUserCerts);
        }
        if (this.onlyContainsCACerts) {
            DerOutputStream doOnlyContainsCACerts = new DerOutputStream();
            doOnlyContainsCACerts.putBoolean(this.onlyContainsCACerts);
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), doOnlyContainsCACerts);
        }
        if (this.reasonFlags != null) {
            DerOutputStream reasons = new DerOutputStream();
            BitArray rf = new BitArray(this.reasonFlags);
            reasons.putUnalignedBitString(rf);
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)3), reasons);
        }
        if (this.indirectCRL) {
            DerOutputStream doIndirectCRL = new DerOutputStream();
            doIndirectCRL.putBoolean(this.indirectCRL);
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)4), doIndirectCRL);
        }
        this.extensionValue = tagged.toByteArray();
    }

    private static String reasonToString(int reason) {
        if (reason > 0 && reason < REASON_STRINGS.length) {
            return REASON_STRINGS[reason];
        }
        return "Unknown reason " + reason;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString() + "IssuingDistributionPoint [\n  ");
        if (this.fullName != null) {
            sb.append("    fullName:\n    " + this.fullName + "\n");
        }
        if (this.relativeName != null) {
            sb.append("    relativeName:\n     " + this.relativeName + "\n");
        }
        sb.append("    onlyContainsUserCerts:\n     " + this.onlyContainsUserCerts + "\n");
        sb.append("    onlyContainsCACerts:\n     " + this.onlyContainsCACerts + "\n");
        if (this.reasonFlags != null) {
            sb.append("   ReasonFlags:\n");
            for (int i = 0; i < this.reasonFlags.length; ++i) {
                if (!this.reasonFlags[i]) continue;
                sb.append("    " + IssuingDistributionPointExtension.reasonToString(i) + "\n");
            }
        }
        sb.append("    indirectCRL:\n     " + this.indirectCRL + "\n");
        return sb.toString();
    }

    private static AVA[] derValueToAVAs(DerValue derValue) throws IOException {
        DerInputStream dis = new DerInputStream(derValue.toByteArray());
        DerValue[] avaset = dis.getSet(5);
        AVA[] avas = new AVA[avaset.length];
        for (int i = 0; i < avaset.length; ++i) {
            DerValue derval = avaset[i];
            avas[i] = new AVA(derval.data.getOID(), derval.data.getDerValue());
        }
        return avas;
    }

    private static void encodeRDN(RDN rdn, DerOutputStream derOut) throws IOException {
        List<AVA> avas = rdn.avas();
        DerEncoder[] avaArray = avas.toArray(new AVA[avas.size()]);
        derOut.putOrderedSetOf((byte)49, avaArray);
    }
}

