/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.ldap;

import com.forgerock.opendj.ldap.controls.TransactionIdControl;
import com.sun.identity.shared.debug.Debug;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.forgerock.openam.audit.context.AuditRequestContext;
import org.forgerock.openam.ldap.LDAPRequests;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;
import org.forgerock.opendj.ldif.LDIFChangeRecordReader;

public final class LdifUtils {
    private static final Debug DEBUG = Debug.getInstance((String)"amUtil");

    private LdifUtils() {
    }

    public static void createSchemaFromLDIF(String file, Connection ld) throws IOException {
        try (FileInputStream fileInput = new FileInputStream(file);){
            LdifUtils.createSchemaFromLDIF(fileInput, ld);
        }
    }

    public static void createSchemaFromLDIF(InputStream stream, Connection ld) throws IOException {
        LdifUtils.createSchemaFromLDIF(new LDIFChangeRecordReader((InputStream)new BufferedInputStream(stream)), ld);
    }

    public static void createSchemaFromLDIF(LDIFChangeRecordReader ldif, final Connection ld) throws IOException {
        while (ldif.hasNext()) {
            final ChangeRecord changeRecord = ldif.readChangeRecord();
            changeRecord.accept((ChangeRecordVisitor)new ChangeRecordVisitor<Void, Void>(){

                public Void visitChangeRecord(Void aVoid, AddRequest change) {
                    try {
                        change.addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
                        ld.add(change);
                    }
                    catch (LdapException e) {
                        if (ResultCode.ENTRY_ALREADY_EXISTS.equals((Object)e.getResult().getResultCode())) {
                            for (Attribute attr : change.getAllAttributes()) {
                                ModifyRequest modifyRequest = LDAPRequests.newModifyRequest(change.getName());
                                modifyRequest.addModification(new Modification(ModificationType.ADD, attr));
                                try {
                                    ld.modify(modifyRequest);
                                }
                                catch (LdapException ex) {
                                    DEBUG.warning("LDAPUtils.createSchemaFromLDIF - Could not modify schema: {}", new Object[]{modifyRequest, ex});
                                }
                            }
                        }
                        DEBUG.warning("LDAPUtils.createSchemaFromLDIF - Could not add to schema: {}", new Object[]{change, e});
                    }
                    return null;
                }

                public Void visitChangeRecord(Void aVoid, ModifyRequest change) {
                    try {
                        change.addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
                        ld.modify(change);
                    }
                    catch (LdapException e) {
                        DEBUG.warning("LDAPUtils.createSchemaFromLDIF - Could not modify schema: {}", new Object[]{change, e});
                    }
                    return null;
                }

                public Void visitChangeRecord(Void aVoid, ModifyDNRequest change) {
                    return null;
                }

                public Void visitChangeRecord(Void aVoid, DeleteRequest change) {
                    DEBUG.message("Delete request ignored: {}", new Object[]{changeRecord});
                    return null;
                }
            }, null);
        }
    }
}

