/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.ldap;

public final class LDAPURL
implements Comparable<LDAPURL> {
    private static final String COLON_SLASH_SLASH = "://";
    private static final int DEFAULT_PORT = 389;
    private static final char SEPARATOR = ':';
    private final String host;
    private final int port;
    private final Boolean isSSL;

    private LDAPURL(String host, int port, Boolean isSSL) {
        this.host = host;
        this.port = port;
        this.isSSL = isSSL;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public Boolean isSSL() {
        return this.isSSL;
    }

    public static LDAPURL valueOf(String url) {
        int port;
        int lastIdx;
        Boolean isSSL = null;
        int firstIdx = url.indexOf(COLON_SLASH_SLASH);
        if (firstIdx != -1) {
            String scheme = url.substring(0, firstIdx);
            isSSL = scheme.equalsIgnoreCase("ldaps") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((lastIdx = url.indexOf(58, firstIdx + 1)) != -1) {
            try {
                port = Integer.parseInt(url.substring(lastIdx + 1));
            }
            catch (NumberFormatException nfe) {
                port = 389;
            }
        } else {
            port = 389;
        }
        firstIdx = firstIdx == -1 ? 0 : firstIdx + COLON_SLASH_SLASH.length();
        lastIdx = lastIdx == -1 ? url.length() : lastIdx;
        String host = url.substring(firstIdx, lastIdx);
        if (port < 1 || port > 65535) {
            port = 389;
        }
        return new LDAPURL(host, port, isSSL);
    }

    public static LDAPURL valueOf(String host, int port) {
        return LDAPURL.valueOf(host, port, null);
    }

    public static LDAPURL valueOf(String host, int port, Boolean isSSL) {
        return new LDAPURL(host, port, isSSL);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.host != null ? this.host.hashCode() : 0);
        hash = 19 * hash + this.port;
        hash = 19 * hash + (this.isSSL != null ? this.isSSL.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LDAPURL other = (LDAPURL)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.isSSL == other.isSSL || this.isSSL != null && this.isSSL.equals(other.isSSL);
    }

    public String toString() {
        if (this.isSSL != null) {
            return (this.isSSL != false ? "ldaps" : "ldap") + COLON_SLASH_SLASH + this.host + ':' + this.port;
        }
        return this.host + ':' + this.port;
    }

    @Override
    public int compareTo(LDAPURL o) {
        return this.toString().compareTo(o.toString());
    }
}

