/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.ldap;

import com.forgerock.opendj.ldap.controls.TransactionIdControl;
import org.forgerock.openam.audit.context.AuditRequestContext;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;

public final class LDAPRequests {
    private LDAPRequests() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static SimpleBindRequest newSimpleBindRequest(String name, char[] password) {
        return Requests.newSimpleBindRequest((String)name, (char[])password).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static ModifyRequest newModifyRequest(String name) {
        return Requests.newModifyRequest((String)name).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static ModifyRequest newModifyRequest(DN dn) {
        return Requests.newModifyRequest((DN)dn).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static SearchRequest newSearchRequest(DN name, SearchScope scope, Filter filter, String ... attributeDescriptions) {
        return Requests.newSearchRequest((DN)name, (SearchScope)scope, (Filter)filter, (String[])attributeDescriptions).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static SearchRequest newSearchRequest(String name, SearchScope scope, String filter, String ... attributeDescriptions) {
        return Requests.newSearchRequest((String)name, (SearchScope)scope, (String)filter, (String[])attributeDescriptions).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static SearchRequest newSingleEntrySearchRequest(DN dn, String ... attributeDescriptions) {
        return Requests.newSingleEntrySearchRequest((DN)dn, (SearchScope)SearchScope.BASE_OBJECT, (Filter)Filter.objectClassPresent(), (String[])attributeDescriptions).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static SearchRequest newSingleEntrySearchRequest(String dn, String ... attributeDescriptions) {
        return Requests.newSingleEntrySearchRequest((String)dn, (SearchScope)SearchScope.BASE_OBJECT, (String)Filter.objectClassPresent().toString(), (String[])attributeDescriptions).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static SearchRequest newSingleEntrySearchRequest(String dn, SearchScope scope, String filter, String ... attributeDescriptions) {
        return Requests.newSingleEntrySearchRequest((String)dn, (SearchScope)scope, (String)filter, (String[])attributeDescriptions).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static AddRequest newAddRequest(String name) {
        return Requests.newAddRequest((String)name).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static AddRequest newAddRequest(DN name) {
        return Requests.newAddRequest((DN)name).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static AddRequest newAddRequest(Entry entry) {
        return Requests.newAddRequest((Entry)entry).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static DeleteRequest newDeleteRequest(String name) {
        return Requests.newDeleteRequest((String)name).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static DeleteRequest newDeleteRequest(DN dn) {
        return Requests.newDeleteRequest((DN)dn).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }

    public static ModifyDNRequest newModifyDNRequest(String name, String newName) {
        return Requests.newModifyDNRequest((String)name, (String)newName).addControl((Control)TransactionIdControl.newControl((String)AuditRequestContext.createSubTransactionIdValue()));
    }
}

