/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.content;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.content.FeatureTypeInfo;
import org.opengis.util.GenericName;

@UML(identifier="MD_FeatureCatalogueDescription", specification=Specification.ISO_19115)
public interface FeatureCatalogueDescription
extends ContentInformation {
    @UML(identifier="complianceCode", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Boolean isCompliant() {
        return null;
    }

    @UML(identifier="locale", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Map<Locale, Charset> getLocalesAndCharsets() {
        return Collections.emptyMap();
    }

    @Deprecated
    @UML(identifier="language", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Collection<Locale> getLanguages() {
        return this.getLocalesAndCharsets().keySet();
    }

    @UML(identifier="includedWithDataset", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public boolean isIncludedWithDataset() {
        return false;
    }

    @UML(identifier="featureTypes", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends FeatureTypeInfo> getFeatureTypeInfo() {
        return Collections.emptyList();
    }

    @Deprecated
    default public Collection<? extends GenericName> getFeatureTypes() {
        ArrayList arrayList = new ArrayList();
        this.getFeatureTypeInfo().forEach(featureTypeInfo -> arrayList.add(featureTypeInfo.getFeatureTypeName()));
        return arrayList;
    }

    @UML(identifier="featureCatalogueCitation", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Citation> getFeatureCatalogueCitations();
}

