/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.referencing.gazetteer;

import java.util.Collection;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.coordinate.Position;
import org.opengis.metadata.citation.Party;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.referencing.gazetteer.LocationType;
import org.opengis.util.InternationalString;

@UML(identifier="SI_LocationInstance", specification=Specification.ISO_19112)
public interface Location {
    @UML(identifier="geographicIdentifier", obligation=Obligation.MANDATORY, specification=Specification.ISO_19112)
    public InternationalString getGeographicIdentifier();

    @UML(identifier="alternativeGeographicIdentifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19112)
    public Collection<? extends InternationalString> getAlternativeGeographicIdentifiers();

    @UML(identifier="temporalExtent", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19112)
    public TemporalExtent getTemporalExtent();

    @UML(identifier="geographicExtent", obligation=Obligation.MANDATORY, specification=Specification.ISO_19112)
    public GeographicExtent getGeographicExtent();

    public Envelope getEnvelope();

    @UML(identifier="position", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19112)
    public Position getPosition();

    @UML(identifier="locationType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19112)
    public LocationType getLocationType();

    @UML(identifier="administrator", obligation=Obligation.MANDATORY, specification=Specification.ISO_19112)
    public Party getAdministrator();

    @UML(identifier="parent", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19112)
    public Collection<? extends Location> getParents();

    @UML(identifier="child", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19112)
    public Collection<? extends Location> getChildren();
}

