/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.opengis.annotation.ComplianceLevel;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Profile;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.MetadataExtensionInformation;
import org.opengis.metadata.MetadataScope;
import org.opengis.metadata.PortrayalCatalogueReference;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.referencing.ReferenceSystem;

@UML(identifier="MD_Metadata", specification=Specification.ISO_19115)
public interface Metadata {
    @UML(identifier="metadataIdentifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Identifier getMetadataIdentifier();

    @Deprecated
    @UML(identifier="fileIdentifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    public String getFileIdentifier();

    @UML(identifier="language", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115, version=2003)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<Locale> getLanguages();

    @Deprecated
    public Locale getLanguage();

    @Deprecated
    @UML(identifier="locale", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    public Collection<Locale> getLocales();

    @UML(identifier="characterSet", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115, version=2003)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<Charset> getCharacterSets();

    @Deprecated
    public CharacterSet getCharacterSet();

    @UML(identifier="parentMetadata", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Citation getParentMetadata();

    @Deprecated
    @UML(identifier="parentIdentifier", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115, version=2003)
    public String getParentIdentifier();

    @UML(identifier="metadataScope", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<? extends MetadataScope> getMetadataScopes();

    @Deprecated
    @UML(identifier="hierarchyLevel", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115, version=2003)
    public Collection<ScopeCode> getHierarchyLevels();

    @Deprecated
    @UML(identifier="hierarchyLevelName", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115, version=2003)
    public Collection<String> getHierarchyLevelNames();

    @UML(identifier="contact", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends Responsibility> getContacts();

    @UML(identifier="dateInfo", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends CitationDate> getDateInfo();

    @Deprecated
    @UML(identifier="dateStamp", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115, version=2003)
    public Date getDateStamp();

    @Deprecated
    @UML(identifier="metadataStandardName", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    public String getMetadataStandardName();

    @Deprecated
    @UML(identifier="metadataStandardVersion", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    @Profile(level=ComplianceLevel.CORE)
    public String getMetadataStandardVersion();

    @UML(identifier="metadataStandard", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends Citation> getMetadataStandards();

    @UML(identifier="metadataProfile", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Citation> getMetadataProfiles();

    @UML(identifier="alternativeMetadataReference", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Citation> getAlternativeMetadataReferences();

    @UML(identifier="metadataLinkage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends OnlineResource> getMetadataLinkages();

    @Deprecated
    @UML(identifier="dataSetURI", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    public String getDataSetUri();

    @UML(identifier="spatialRepresentationInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends SpatialRepresentation> getSpatialRepresentationInfo();

    @UML(identifier="referenceSystemInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends ReferenceSystem> getReferenceSystemInfo();

    @UML(identifier="metadataExtensionInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends MetadataExtensionInformation> getMetadataExtensionInfo();

    @UML(identifier="identificationInfo", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends Identification> getIdentificationInfo();

    @UML(identifier="contentInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends ContentInformation> getContentInfo();

    @UML(identifier="distributionInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends Distribution> getDistributionInfo();

    @UML(identifier="dataQualityInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends DataQuality> getDataQualityInfo();

    @UML(identifier="portrayalCatalogueInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends PortrayalCatalogueReference> getPortrayalCatalogueInfo();

    @UML(identifier="metadataConstraints", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Constraints> getMetadataConstraints();

    @UML(identifier="applicationSchemaInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends ApplicationSchemaInformation> getApplicationSchemaInfo();

    @UML(identifier="acquisitionInformation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115_2)
    public Collection<? extends AcquisitionInformation> getAcquisitionInformation();

    @UML(identifier="metadataMaintenance", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public MaintenanceInformation getMetadataMaintenance();

    @UML(identifier="resourceLineage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Lineage> getResourceLineages();
}

