/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.constraint;

import java.util.ArrayList;
import java.util.List;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.util.CodeList;

@UML(identifier="MD_RestrictionCode", specification=Specification.ISO_19115)
public final class Restriction
extends CodeList<Restriction> {
    private static final long serialVersionUID = 7949159742645339894L;
    private static final List<Restriction> VALUES = new ArrayList<Restriction>(17);
    @UML(identifier="copyright", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction COPYRIGHT = new Restriction("COPYRIGHT");
    @UML(identifier="patent", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction PATENT = new Restriction("PATENT");
    @UML(identifier="patentPending", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction PATENT_PENDING = new Restriction("PATENT_PENDING");
    @UML(identifier="trademark", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction TRADEMARK = new Restriction("TRADEMARK");
    @UML(identifier="licence", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction LICENCE;
    @Deprecated
    @UML(identifier="license", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115, version=2003)
    public static final Restriction LICENSE;
    @UML(identifier="intellectualPropertyRights", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction INTELLECTUAL_PROPERTY_RIGHTS;
    @UML(identifier="restricted", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction RESTRICTED;
    @UML(identifier="otherRestrictions", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction OTHER_RESTRICTIONS;
    @UML(identifier="unrestricted", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction UNRESTRICTED;
    @UML(identifier="licenceUnrestricted", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction LICENCE_UNRESTRICTED;
    @UML(identifier="licenceEndUser", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction LICENCE_END_USER;
    @UML(identifier="licenceDistributor", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction LICENCE_DISTRIBUTOR;
    @UML(identifier="private", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction PRIVATE;
    @UML(identifier="statutory", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction STATUTORY;
    @UML(identifier="confidential", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction CONFIDENTIAL;
    @UML(identifier="sensitiveButUnclassified", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction SENSITIVE_BUT_UNCLASSIFIED;
    @UML(identifier="in-confidence", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final Restriction IN_CONFIDENCE;

    private Restriction(String string) {
        super(string, VALUES);
    }

    @Override
    public String[] names() {
        if (this == LICENSE) {
            return new String[]{this.name(), "LICENSE", this.identifier(), "license"};
        }
        return super.names();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Restriction[] values() {
        List<Restriction> list = VALUES;
        synchronized (list) {
            return VALUES.toArray(new Restriction[VALUES.size()]);
        }
    }

    public Restriction[] family() {
        return Restriction.values();
    }

    public static Restriction valueOf(String string) {
        if ("LICENSE".equals(string)) {
            string = "LICENCE";
        }
        return Restriction.valueOf(Restriction.class, string);
    }

    static {
        LICENSE = LICENCE = new Restriction("LICENCE");
        INTELLECTUAL_PROPERTY_RIGHTS = new Restriction("INTELLECTUAL_PROPERTY_RIGHTS");
        RESTRICTED = new Restriction("RESTRICTED");
        OTHER_RESTRICTIONS = new Restriction("OTHER_RESTRICTIONS");
        UNRESTRICTED = new Restriction("UNRESTRICTED");
        LICENCE_UNRESTRICTED = new Restriction("LICENCE_UNRESTRICTED");
        LICENCE_END_USER = new Restriction("LICENCE_END_USER");
        LICENCE_DISTRIBUTOR = new Restriction("LICENCE_DISTRIBUTOR");
        PRIVATE = new Restriction("PRIVATE");
        STATUTORY = new Restriction("STATUTORY");
        CONFIDENTIAL = new Restriction("CONFIDENTIAL");
        SENSITIVE_BUT_UNCLASSIFIED = new Restriction("SENSITIVE_BUT_UNCLASSIFIED");
        IN_CONFIDENCE = new Restriction("IN_CONFIDENCE");
    }
}

