/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test;

import java.util.AbstractList;
import java.util.List;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicDescription;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.Formula;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.test.Validator;
import org.opengis.test.geometry.GeometryValidator;
import org.opengis.test.metadata.CitationValidator;
import org.opengis.test.metadata.ExtentValidator;
import org.opengis.test.referencing.CRSValidator;
import org.opengis.test.referencing.CSValidator;
import org.opengis.test.referencing.DatumValidator;
import org.opengis.test.referencing.OperationValidator;
import org.opengis.test.referencing.ParameterValidator;
import org.opengis.test.util.NameValidator;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

public class ValidatorContainer {
    public NameValidator naming = new NameValidator(this);
    public CitationValidator citation = new CitationValidator(this);
    public ExtentValidator extent = new ExtentValidator(this);
    public DatumValidator datum = new DatumValidator(this);
    public CSValidator cs = new CSValidator(this);
    public CRSValidator crs = new CRSValidator(this);
    public ParameterValidator parameter = new ParameterValidator(this);
    public OperationValidator coordinateOperation = new OperationValidator(this);
    public GeometryValidator geometry = new GeometryValidator(this);
    public final List<Validator> all = new AbstractList<Validator>(){

        @Override
        public int size() {
            return 9;
        }

        @Override
        public Validator get(int n) {
            switch (n) {
                case 0: {
                    return ValidatorContainer.this.naming;
                }
                case 1: {
                    return ValidatorContainer.this.citation;
                }
                case 2: {
                    return ValidatorContainer.this.extent;
                }
                case 3: {
                    return ValidatorContainer.this.datum;
                }
                case 4: {
                    return ValidatorContainer.this.cs;
                }
                case 5: {
                    return ValidatorContainer.this.crs;
                }
                case 6: {
                    return ValidatorContainer.this.parameter;
                }
                case 7: {
                    return ValidatorContainer.this.coordinateOperation;
                }
                case 8: {
                    return ValidatorContainer.this.geometry;
                }
            }
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
    };

    public final void dispatch(Object object) {
        if (object instanceof InternationalString) {
            this.validate((InternationalString)object);
        } else if (object instanceof ReferenceIdentifier) {
            this.validate((ReferenceIdentifier)object);
        } else if (object instanceof Citation) {
            this.validate((Citation)object);
        } else if (object instanceof GenericName) {
            this.validate((GenericName)object);
        } else if (object instanceof NameSpace) {
            this.validate((NameSpace)object);
        } else if (object instanceof IdentifiedObject) {
            this.validate((IdentifiedObject)object);
        } else if (object instanceof GeneralParameterValue) {
            this.validate((GeneralParameterValue)object);
        } else if (object instanceof DirectPosition) {
            this.validate((DirectPosition)object);
        } else if (object instanceof Envelope) {
            this.validate((Envelope)object);
        } else if (object instanceof GeographicExtent) {
            this.validate((GeographicExtent)object);
        } else if (object instanceof VerticalExtent) {
            this.validate((VerticalExtent)object);
        } else if (object instanceof TemporalExtent) {
            this.validate((TemporalExtent)object);
        } else if (object instanceof Extent) {
            this.validate((Extent)object);
        }
    }

    public final void validate(Extent extent) {
        this.extent.validate(extent);
    }

    public final void validate(TemporalExtent temporalExtent) {
        this.extent.validate(temporalExtent);
    }

    public final void validate(VerticalExtent verticalExtent) {
        this.extent.validate(verticalExtent);
    }

    public final void validate(GeographicExtent geographicExtent) {
        this.extent.dispatch(geographicExtent);
    }

    public final void validate(GeographicDescription geographicDescription) {
        this.extent.validate(geographicDescription);
    }

    public final void validate(BoundingPolygon boundingPolygon) {
        this.extent.validate(boundingPolygon);
    }

    public final void validate(GeographicBoundingBox geographicBoundingBox) {
        this.extent.validate(geographicBoundingBox);
    }

    public final void validate(Envelope envelope) {
        this.geometry.validate(envelope);
    }

    public final void validate(DirectPosition directPosition) {
        this.geometry.validate(directPosition);
    }

    public final void validate(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.crs.dispatch(coordinateReferenceSystem);
    }

    public final void validate(GeocentricCRS geocentricCRS) {
        this.crs.validate(geocentricCRS);
    }

    public final void validate(GeographicCRS geographicCRS) {
        this.crs.validate(geographicCRS);
    }

    public final void validate(ProjectedCRS projectedCRS) {
        this.crs.validate(projectedCRS);
    }

    public final void validate(DerivedCRS derivedCRS) {
        this.crs.validate(derivedCRS);
    }

    public final void validate(ImageCRS imageCRS) {
        this.crs.validate(imageCRS);
    }

    public final void validate(EngineeringCRS engineeringCRS) {
        this.crs.validate(engineeringCRS);
    }

    public final void validate(VerticalCRS verticalCRS) {
        this.crs.validate(verticalCRS);
    }

    public final void validate(TemporalCRS temporalCRS) {
        this.crs.validate(temporalCRS);
    }

    public final void validate(CoordinateSystem coordinateSystem) {
        this.cs.dispatch(coordinateSystem);
    }

    public final void validate(CartesianCS cartesianCS) {
        this.cs.validate(cartesianCS);
    }

    public final void validate(EllipsoidalCS ellipsoidalCS) {
        this.cs.validate(ellipsoidalCS);
    }

    public final void validate(SphericalCS sphericalCS) {
        this.cs.validate(sphericalCS);
    }

    public final void validate(CylindricalCS cylindricalCS) {
        this.cs.validate(cylindricalCS);
    }

    public final void validate(PolarCS polarCS) {
        this.cs.validate(polarCS);
    }

    public final void validate(LinearCS linearCS) {
        this.cs.validate(linearCS);
    }

    public final void validate(VerticalCS verticalCS) {
        this.cs.validate(verticalCS);
    }

    public final void validate(TimeCS timeCS) {
        this.cs.validate(timeCS);
    }

    public final void validate(UserDefinedCS userDefinedCS) {
        this.cs.validate(userDefinedCS);
    }

    public final void validate(CoordinateSystemAxis coordinateSystemAxis) {
        this.cs.validate(coordinateSystemAxis);
    }

    public final void validate(Datum datum) {
        this.datum.dispatch(datum);
    }

    public final void validate(PrimeMeridian primeMeridian) {
        this.datum.validate(primeMeridian);
    }

    public final void validate(Ellipsoid ellipsoid) {
        this.datum.validate(ellipsoid);
    }

    public final void validate(GeodeticDatum geodeticDatum) {
        this.datum.validate(geodeticDatum);
    }

    public final void validate(VerticalDatum verticalDatum) {
        this.datum.validate(verticalDatum);
    }

    public final void validate(TemporalDatum temporalDatum) {
        this.datum.validate(temporalDatum);
    }

    public final void validate(ImageDatum imageDatum) {
        this.datum.validate(imageDatum);
    }

    public final void validate(EngineeringDatum engineeringDatum) {
        this.datum.validate(engineeringDatum);
    }

    public final void validate(CoordinateOperation coordinateOperation) {
        this.coordinateOperation.dispatch(coordinateOperation);
    }

    public final void validate(Conversion conversion) {
        this.coordinateOperation.validate(conversion);
    }

    public final void validate(Transformation transformation) {
        this.coordinateOperation.validate(transformation);
    }

    public final void validate(ConcatenatedOperation concatenatedOperation) {
        this.coordinateOperation.validate(concatenatedOperation);
    }

    public final void validate(PassThroughOperation passThroughOperation) {
        this.coordinateOperation.validate(passThroughOperation);
    }

    public final void validate(OperationMethod operationMethod) {
        this.coordinateOperation.validate(operationMethod);
    }

    public final void validate(Formula formula) {
        this.coordinateOperation.validate(formula);
    }

    public final void validate(MathTransform mathTransform) {
        this.coordinateOperation.validate(mathTransform);
    }

    public final void validate(GeneralParameterDescriptor generalParameterDescriptor) {
        this.parameter.dispatch(generalParameterDescriptor);
    }

    public final void validate(ParameterDescriptor<?> parameterDescriptor) {
        this.parameter.validate(parameterDescriptor);
    }

    public final void validate(ParameterDescriptorGroup parameterDescriptorGroup) {
        this.parameter.validate(parameterDescriptorGroup);
    }

    public final void validate(GeneralParameterValue generalParameterValue) {
        this.parameter.dispatch(generalParameterValue);
    }

    public final void validate(ParameterValue<?> parameterValue) {
        this.parameter.validate(parameterValue);
    }

    public final void validate(ParameterValueGroup parameterValueGroup) {
        this.parameter.validate(parameterValueGroup);
    }

    public final void validate(IdentifiedObject identifiedObject) {
        this.crs.dispatchObject(identifiedObject);
    }

    public final void validate(ReferenceIdentifier referenceIdentifier) {
        this.crs.validate(referenceIdentifier);
    }

    public final void validate(Citation citation) {
        this.citation.validate(citation);
    }

    public final void validate(GenericName genericName) {
        this.naming.dispatch(genericName);
    }

    public final void validate(LocalName localName) {
        this.naming.validate(localName);
    }

    public final void validate(ScopedName scopedName) {
        this.naming.validate(scopedName);
    }

    public final void validate(NameSpace nameSpace) {
        this.naming.validate(nameSpace);
    }

    public final void validate(InternationalString internationalString) {
        this.naming.validate(internationalString);
    }
}

