/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import com.qualcomm.robotcore.util.RobotLog;
import java.lang.reflect.Field;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.external.ClassFactory;
import org.firstinspires.ftc.robotcore.external.android.util.Size;
import org.firstinspires.ftc.robotcore.external.function.Continuation;
import org.firstinspires.ftc.robotcore.external.hardware.camera.Camera;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraCaptureRequest;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraCaptureSequenceId;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraCaptureSession;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraCharacteristics;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraException;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraFrame;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraName;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.ExposureControl;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.FocusControl;
import org.firstinspires.ftc.robotcore.internal.camera.CameraManagerInternal;
import org.firstinspires.ftc.robotcore.internal.camera.ImageFormatMapper;
import org.firstinspires.ftc.robotcore.internal.camera.RenumberedCameraFrame;
import org.firstinspires.ftc.robotcore.internal.camera.libuvc.api.UvcApiCameraFrame;
import org.firstinspires.ftc.robotcore.internal.camera.libuvc.nativeobject.UvcFrame;
import org.firstinspires.ftc.robotcore.internal.system.Deadline;
import org.firstinspires.ftc.robotcore.internal.vuforia.externalprovider.CameraMode;
import org.firstinspires.ftc.robotcore.internal.vuforia.externalprovider.FrameFormat;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;
import org.openftc.easyopencv.OpenCvCamera;
import org.openftc.easyopencv.OpenCvCameraBase;
import org.openftc.easyopencv.OpenCvCameraException;
import org.openftc.easyopencv.OpenCvCameraRotation;
import org.openftc.easyopencv.OpenCvWebcam;

class OpenCvWebcamImpl
extends OpenCvCameraBase
implements OpenCvWebcam,
CameraCaptureSession.CaptureCallback {
    private final CameraManagerInternal cameraManager;
    private final Executor serialThreadPool;
    private final int secondsPermissionTimeout = 2;
    private final CameraName cameraName;
    private CameraCharacteristics cameraCharacteristics = null;
    protected Camera camera = null;
    private CameraCaptureSession cameraCaptureSession = null;
    private Mat rawSensorMat;
    private Mat rgbMat;
    private byte[] imgDat;
    protected volatile boolean isOpen = false;
    private volatile boolean isStreaming = false;
    private final Object sync = new Object();
    private final Object newFrameSync = new Object();
    private boolean abortNewFrameCallback = false;
    private volatile boolean hasSeenFrame = false;
    private ExposureControl exposureControl;
    private FocusControl focusControl;

    public OpenCvWebcamImpl(CameraName cameraName) {
        this.cameraManager = (CameraManagerInternal)ClassFactory.getInstance().getCameraManager();
        this.serialThreadPool = this.cameraManager.getSerialThreadPool();
        this.cameraName = cameraName;
    }

    public OpenCvWebcamImpl(CameraName cameraName, int containerLayoutId) {
        super(containerLayoutId);
        this.cameraManager = (CameraManagerInternal)ClassFactory.getInstance().getCameraManager();
        this.serialThreadPool = this.cameraManager.getSerialThreadPool();
        this.cameraName = cameraName;
    }

    public CameraCharacteristics getCameraCharacteristics() {
        return this.cameraCharacteristics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openCameraDevice() {
        Object object = this.sync;
        synchronized (object) {
            if (this.hasBeenCleanedUp()) {
                return;
            }
            if (!this.isOpen) {
                try {
                    this.camera = this.cameraManager.requestPermissionAndOpenCamera(new Deadline(2L, TimeUnit.SECONDS), this.cameraName, null);
                    if (this.camera != null) {
                        this.cameraCharacteristics = this.camera.getCameraName().getCameraCharacteristics();
                        this.isOpen = true;
                        this.exposureControl = (ExposureControl)this.camera.getControl(ExposureControl.class);
                        this.focusControl = (FocusControl)this.camera.getControl(FocusControl.class);
                    } else {
                        this.cameraCharacteristics = this.cameraName.getCameraCharacteristics();
                    }
                }
                catch (Exception e) {
                    this.camera = null;
                    throw e;
                }
            }
        }
    }

    @Override
    public void openCameraDeviceAsync(final OpenCvCamera.AsyncCameraOpenListener asyncCameraOpenListener) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = OpenCvWebcamImpl.this.sync;
                synchronized (object) {
                    try {
                        OpenCvWebcamImpl.this.openCameraDevice();
                        asyncCameraOpenListener.onOpened();
                    }
                    catch (Exception e) {
                        if (!OpenCvWebcamImpl.this.hasBeenCleanedUp()) {
                            OpenCvWebcamImpl.this.emulateEStop(e);
                        }
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeCameraDevice() {
        Object object = this.sync;
        synchronized (object) {
            this.cleanupForClosingCamera();
            if (this.isOpen) {
                if (this.camera != null) {
                    this.stopStreaming();
                    this.camera.close();
                    this.camera = null;
                }
                this.isOpen = false;
            }
        }
    }

    @Override
    public void closeCameraDeviceAsync(final OpenCvCamera.AsyncCameraCloseListener asyncCameraCloseListener) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = OpenCvWebcamImpl.this.sync;
                synchronized (object) {
                    try {
                        OpenCvWebcamImpl.this.closeCameraDevice();
                        asyncCameraCloseListener.onClose();
                    }
                    catch (Exception e) {
                        if (!OpenCvWebcamImpl.this.hasBeenCleanedUp()) {
                            OpenCvWebcamImpl.this.emulateEStop(e);
                        }
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    @Override
    public void startStreaming(int width, int height) {
        this.startStreaming(width, height, this.getDefaultRotation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStreaming(final int width, final int height, OpenCvCameraRotation rotation) {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isOpen) {
                throw new OpenCvCameraException("startStreaming() called, but camera is not opened!");
            }
            if (this.isStreaming) {
                this.stopStreaming();
            }
            this.prepareForStartStreaming(width, height, rotation);
            final CountDownLatch captureStartResult = new CountDownLatch(1);
            boolean sizeSupported = false;
            for (Size s : this.cameraCharacteristics.getSizes(20)) {
                if (s.getHeight() != height || s.getWidth() != width) continue;
                sizeSupported = true;
                break;
            }
            if (!sizeSupported) {
                StringBuilder supportedSizesBuilder = new StringBuilder();
                for (Size s : this.cameraCharacteristics.getSizes(20)) {
                    supportedSizesBuilder.append(String.format("[%dx%d], ", s.getWidth(), s.getHeight()));
                }
                throw new OpenCvCameraException("Camera does not support requested resolution! Supported resolutions are " + supportedSizesBuilder.toString());
            }
            try {
                this.camera.createCaptureSession(Continuation.create((Executor)this.serialThreadPool, (Object)new CameraCaptureSession.StateCallback(){

                    public void onConfigured(CameraCaptureSession session) {
                        try {
                            CameraMode streamingMode = new CameraMode(width, height, OpenCvWebcamImpl.this.cameraCharacteristics.getMaxFramesPerSecond(ImageFormatMapper.androidFromVuforiaWebcam((FrameFormat)FrameFormat.YUYV), new Size(width, height)), FrameFormat.YUYV);
                            CameraCaptureRequest cameraCaptureRequest = OpenCvWebcamImpl.this.camera.createCaptureRequest(streamingMode.getAndroidFormat(), streamingMode.getSize(), streamingMode.getFramesPerSecond());
                            session.startCapture(cameraCaptureRequest, (CameraCaptureSession.CaptureCallback)OpenCvWebcamImpl.this, Continuation.create((Executor)OpenCvWebcamImpl.this.serialThreadPool, (Object)new CameraCaptureSession.StatusCallback(){

                                public void onCaptureSequenceCompleted(CameraCaptureSession session, CameraCaptureSequenceId cameraCaptureSequenceId, long lastFrameNumber) {
                                    RobotLog.d((String)"capture sequence %s reports completed: lastFrame=%d", (Object[])new Object[]{cameraCaptureSequenceId, lastFrameNumber});
                                }
                            }));
                        }
                        catch (RuntimeException | CameraException e) {
                            e.printStackTrace();
                            RobotLog.e((String)"exception setting repeat capture request: closing session: %s", (Object[])new Object[]{session});
                            session.close();
                            session = null;
                        }
                        System.out.println("OpenCvWebcam: onConfigured");
                        OpenCvWebcamImpl.this.cameraCaptureSession = session;
                        captureStartResult.countDown();
                    }

                    public void onClosed(CameraCaptureSession session) {
                    }
                }));
            }
            catch (RuntimeException | CameraException e) {
                System.out.println("OpenCvWebcam: exception starting capture");
                captureStartResult.countDown();
            }
            try {
                captureStartResult.await(1L, TimeUnit.SECONDS);
                System.out.println("OpenCvWebcam: streaming started");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.isStreaming = true;
        }
    }

    @Override
    protected OpenCvCameraRotation getDefaultRotation() {
        return OpenCvCameraRotation.SIDEWAYS_LEFT;
    }

    @Override
    protected int mapRotationEnumToOpenCvRotateCode(OpenCvCameraRotation rotation) {
        if (rotation == OpenCvCameraRotation.SIDEWAYS_LEFT) {
            return 2;
        }
        if (rotation == OpenCvCameraRotation.SIDEWAYS_RIGHT) {
            return 0;
        }
        if (rotation == OpenCvCameraRotation.UPSIDE_DOWN) {
            return 1;
        }
        return -1;
    }

    @Override
    protected boolean cameraOrientationIsTiedToDeviceOrientation() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStreaming() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isOpen) {
                throw new OpenCvCameraException("stopStreaming() called, but camera is not opened!");
            }
            Object object2 = this.newFrameSync;
            synchronized (object2) {
                this.abortNewFrameCallback = true;
                this.cleanupForEndStreaming();
                this.imgDat = null;
                this.rgbMat = null;
                this.rawSensorMat = null;
            }
            if (this.cameraCaptureSession != null) {
                boolean wasInterrupted = false;
                while (!this.hasSeenFrame) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        wasInterrupted = true;
                    }
                }
                this.cameraCaptureSession.stopCapture();
                this.cameraCaptureSession.close();
                this.cameraCaptureSession = null;
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            this.isStreaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewFrame(CameraCaptureSession session, CameraCaptureRequest request, CameraFrame cameraFrame) {
        this.hasSeenFrame = true;
        Object object = this.newFrameSync;
        synchronized (object) {
            if (this.abortNewFrameCallback) {
                return;
            }
            this.notifyStartOfFrameProcessing();
            if (this.imgDat == null) {
                this.imgDat = new byte[cameraFrame.getImageSize()];
            }
            if (this.rgbMat == null) {
                this.rgbMat = new Mat(cameraFrame.getSize().getHeight(), cameraFrame.getSize().getWidth(), CvType.CV_8UC1);
            }
            if (this.rawSensorMat == null) {
                this.rawSensorMat = new Mat(cameraFrame.getSize().getHeight(), cameraFrame.getSize().getWidth(), CvType.CV_8UC2);
            }
            try {
                RenumberedCameraFrame renumberedCameraFrame = (RenumberedCameraFrame)cameraFrame;
                Field innerFrameField = RenumberedCameraFrame.class.getDeclaredField("innerFrame");
                innerFrameField.setAccessible(true);
                CameraFrame innerFrame = (CameraFrame)innerFrameField.get(renumberedCameraFrame);
                if (innerFrame instanceof RenumberedCameraFrame) {
                    innerFrame = (CameraFrame)innerFrameField.get(innerFrame);
                }
                UvcApiCameraFrame uvcApiCameraFrame = (UvcApiCameraFrame)innerFrame;
                Field uvcFrameField = UvcApiCameraFrame.class.getDeclaredField("uvcFrame");
                uvcFrameField.setAccessible(true);
                UvcFrame uvcFrame = (UvcFrame)uvcFrameField.get(uvcApiCameraFrame);
                uvcFrame.getImageData(this.imgDat);
                this.rawSensorMat.put(0, 0, this.imgDat);
                Imgproc.cvtColor((Mat)this.rawSensorMat, (Mat)this.rgbMat, (int)119, (int)4);
                this.handleFrame(this.rgbMat);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ExposureControl getExposureControl() {
        return this.exposureControl;
    }

    @Override
    public FocusControl getFocusControl() {
        return this.focusControl;
    }
}

