/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.firstinspires.ftc.robotcore.external.android.util.Size;
import org.firstinspires.ftc.robotcore.external.function.Consumer;
import org.firstinspires.ftc.robotcore.internal.collections.EvictingBlockingQueue;
import org.opencv.android.Utils;
import org.opencv.core.Mat;
import org.openftc.easyopencv.MatRecycler;
import org.openftc.easyopencv.OpenCvCamera;

public class OpenCvViewport
extends SurfaceView
implements SurfaceHolder.Callback {
    private Size size;
    private Bitmap bitmapFromMat;
    private RenderThread renderThread;
    private Canvas canvas = null;
    private double aspectRatio;
    private static final int VISION_PREVIEW_FRAME_QUEUE_CAPACITY = 2;
    private static final int FRAMEBUFFER_RECYCLER_CAPACITY = 4;
    private EvictingBlockingQueue<MatRecycler.RecyclableMat> visionPreviewFrameQueue = new EvictingBlockingQueue(new ArrayBlockingQueue(2));
    private MatRecycler framebufferRecycler;
    private volatile RenderingState internalRenderingState = RenderingState.STOPPED;
    private final Object syncObj = new Object();
    private volatile boolean userRequestedActive = false;
    private volatile boolean userRequestedPause = false;
    private boolean needToDeactivateRegardlessOfUser = false;
    private boolean surfaceExistsAndIsReady = false;
    private Paint fpsMeterBgPaint;
    private Paint fpsMeterTextPaint;
    private boolean fpsMeterEnabled = true;
    private float fps = 0.0f;
    private int pipelineMs = 0;
    private int overheadMs = 0;
    private String TAG = "OpenCvViewport";
    private ReentrantLock renderThreadAliveLock = new ReentrantLock();
    private volatile OptimizedRotation optimizedViewRotation;
    private volatile OpenCvCamera.ViewportRenderingPolicy renderingPolicy = OpenCvCamera.ViewportRenderingPolicy.MAXIMIZE_EFFICIENCY;

    public OpenCvViewport(Context context, View.OnClickListener onClickListener) {
        super(context);
        this.fpsMeterBgPaint = new Paint();
        this.fpsMeterBgPaint.setColor(Color.rgb((int)102, (int)20, (int)68));
        this.fpsMeterBgPaint.setStyle(Paint.Style.FILL);
        this.fpsMeterTextPaint = new Paint();
        this.fpsMeterTextPaint.setColor(-1);
        this.fpsMeterTextPaint.setTextSize(30.0f);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.visionPreviewFrameQueue.setEvictAction((Consumer)new Consumer<MatRecycler.RecyclableMat>(){

            public void accept(MatRecycler.RecyclableMat value) {
                OpenCvViewport.this.framebufferRecycler.returnMat(value);
            }
        });
        this.setOnClickListener(onClickListener);
    }

    public void setRenderingPolicy(OpenCvCamera.ViewportRenderingPolicy policy) {
        this.renderingPolicy = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(Size size) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.internalRenderingState != RenderingState.STOPPED) {
                throw new IllegalStateException("Cannot set size while renderer is active!");
            }
            if (size == null) {
                throw new IllegalArgumentException("size cannot be null!");
            }
            this.size = size;
            this.aspectRatio = (double)size.getWidth() / (double)size.getHeight();
            this.visionPreviewFrameQueue.clear();
            this.framebufferRecycler = new MatRecycler(4);
        }
    }

    public void setOptimizedViewRotation(OptimizedRotation optimizedViewRotation) {
        this.optimizedViewRotation = optimizedViewRotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Mat mat) {
        Object object = this.syncObj;
        synchronized (object) {
            if (mat == null) {
                throw new IllegalArgumentException("cannot post null mat!");
            }
            if (this.internalRenderingState == RenderingState.ACTIVE) {
                try {
                    MatRecycler.RecyclableMat matToCopyTo = this.framebufferRecycler.takeMat();
                    mat.copyTo((Mat)matToCopyTo);
                    this.visionPreviewFrameQueue.offer((Object)matToCopyTo);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void checkState() {
        if (!this.surfaceExistsAndIsReady) {
            Log.d((String)this.TAG, (String)"CheckState(): surface not ready or doesn't exist");
            return;
        }
        if (!this.userRequestedActive || this.needToDeactivateRegardlessOfUser) {
            if (this.needToDeactivateRegardlessOfUser) {
                Log.d((String)this.TAG, (String)"CheckState(): lifecycle mandates deactivation regardless of user");
            } else {
                Log.d((String)this.TAG, (String)"CheckState(): user requested that we deactivate");
            }
            if (this.internalRenderingState != RenderingState.STOPPED) {
                Log.d((String)this.TAG, (String)"CheckState(): deactivating viewport");
                this.renderThread.notifyExitRequested();
                this.renderThread.interrupt();
                this.renderThreadAliveLock.lock();
                this.renderThreadAliveLock.unlock();
                this.internalRenderingState = RenderingState.STOPPED;
            } else {
                Log.d((String)this.TAG, (String)"CheckState(): already deactivated");
            }
        } else if (this.userRequestedActive) {
            Log.d((String)this.TAG, (String)"CheckState(): user requested that we activate");
            if (this.internalRenderingState == RenderingState.STOPPED) {
                Log.d((String)this.TAG, (String)"CheckState(): activating viewport");
                this.internalRenderingState = RenderingState.PAUSED;
                this.internalRenderingState = this.userRequestedPause ? RenderingState.PAUSED : RenderingState.ACTIVE;
                this.renderThread = new RenderThread();
                this.renderThread.start();
            } else {
                Log.d((String)this.TAG, (String)"CheckState(): already activated");
            }
        }
        if (this.internalRenderingState != RenderingState.STOPPED && (this.userRequestedPause && this.internalRenderingState != RenderingState.PAUSED || !this.userRequestedPause && this.internalRenderingState != RenderingState.ACTIVE)) {
            if (this.userRequestedPause) {
                Log.d((String)this.TAG, (String)"CheckState(): pausing viewport");
                this.internalRenderingState = RenderingState.PAUSED;
            } else {
                Log.d((String)this.TAG, (String)"CheckState(): resuming viewport");
                this.internalRenderingState = RenderingState.ACTIVE;
            }
            this.renderThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void activate() {
        Object object = this.syncObj;
        synchronized (object) {
            this.userRequestedActive = true;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deactivate() {
        Object object = this.syncObj;
        synchronized (object) {
            this.userRequestedActive = false;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume() {
        Object object = this.syncObj;
        synchronized (object) {
            this.userRequestedPause = false;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pause() {
        Object object = this.syncObj;
        synchronized (object) {
            this.userRequestedPause = true;
            this.checkState();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Object object = this.syncObj;
        synchronized (object) {
            this.needToDeactivateRegardlessOfUser = false;
            this.surfaceExistsAndIsReady = true;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed(SurfaceHolder holder) {
        Object object = this.syncObj;
        synchronized (object) {
            this.needToDeactivateRegardlessOfUser = true;
            this.checkState();
            this.surfaceExistsAndIsReady = false;
        }
    }

    public void setFpsMeterEnabled(boolean fpsMeterEnabled) {
        this.fpsMeterEnabled = fpsMeterEnabled;
    }

    public void notifyStatistics(float fps, int pipelineMs, int overheadMs) {
        this.fps = fps;
        this.pipelineMs = pipelineMs;
        this.overheadMs = overheadMs;
    }

    @SuppressLint(value={"DefaultLocale"})
    public String getFpsString() {
        return String.format("FPS@%dx%d: %.2f", this.size.getWidth(), this.size.getHeight(), Float.valueOf(this.fps));
    }

    Rect createRect(int tlx, int tly, int w, int h) {
        return new Rect(tlx, tly, tlx + w, tly + h);
    }

    class RenderThread
    extends Thread {
        boolean shouldPaintOrange = true;
        volatile boolean exitRequested = false;
        private String TAG = "OpenCvViewportRenderThread";

        RenderThread() {
        }

        public void notifyExitRequested() {
            this.exitRequested = true;
        }

        @Override
        public void run() {
            OpenCvViewport.this.renderThreadAliveLock.lock();
            OpenCvViewport.this.visionPreviewFrameQueue.clear();
            Log.d((String)this.TAG, (String)"I am alive!");
            OpenCvViewport.this.bitmapFromMat = Bitmap.createBitmap((int)OpenCvViewport.this.size.getWidth(), (int)OpenCvViewport.this.size.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            OpenCvViewport.this.canvas = OpenCvViewport.this.getHolder().lockCanvas();
            OpenCvViewport.this.canvas.drawColor(-16776961);
            OpenCvViewport.this.getHolder().unlockCanvasAndPost(OpenCvViewport.this.canvas);
            while (!this.exitRequested) {
                switch (OpenCvViewport.this.internalRenderingState) {
                    case ACTIVE: {
                        MatRecycler.RecyclableMat mat;
                        this.shouldPaintOrange = true;
                        try {
                            mat = (MatRecycler.RecyclableMat)((Object)OpenCvViewport.this.visionPreviewFrameQueue.take());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            break;
                        }
                        OpenCvViewport.this.canvas = OpenCvViewport.this.getHolder().lockCanvas();
                        if (OpenCvViewport.this.canvas != null) {
                            Utils.matToBitmap((Mat)mat, (Bitmap)OpenCvViewport.this.bitmapFromMat);
                            OpenCvViewport.this.canvas.drawColor(-16777216);
                            if (OpenCvViewport.this.renderingPolicy == OpenCvCamera.ViewportRenderingPolicy.MAXIMIZE_EFFICIENCY) {
                                this.drawOptimizingEfficiency(OpenCvViewport.this.canvas);
                            } else if (OpenCvViewport.this.renderingPolicy == OpenCvCamera.ViewportRenderingPolicy.OPTIMIZE_VIEW) {
                                this.drawOptimizingView(OpenCvViewport.this.canvas);
                            }
                            OpenCvViewport.this.getHolder().unlockCanvasAndPost(OpenCvViewport.this.canvas);
                        } else {
                            Log.d((String)this.TAG, (String)"Canvas was null");
                        }
                        OpenCvViewport.this.framebufferRecycler.returnMat(mat);
                        break;
                    }
                    case PAUSED: {
                        if (this.shouldPaintOrange) {
                            this.shouldPaintOrange = false;
                            OpenCvViewport.this.canvas = OpenCvViewport.this.getHolder().lockCanvas();
                            if (OpenCvViewport.this.canvas != null) {
                                OpenCvViewport.this.canvas.drawColor(Color.rgb((int)255, (int)166, (int)0));
                                OpenCvViewport.this.canvas.drawRect(0.0f, (float)(OpenCvViewport.this.canvas.getHeight() - 40), 450.0f, (float)OpenCvViewport.this.canvas.getHeight(), OpenCvViewport.this.fpsMeterBgPaint);
                                OpenCvViewport.this.canvas.drawText("VIEWPORT PAUSED", 5.0f, (float)(OpenCvViewport.this.canvas.getHeight() - 10), OpenCvViewport.this.fpsMeterTextPaint);
                                OpenCvViewport.this.getHolder().unlockCanvasAndPost(OpenCvViewport.this.canvas);
                            }
                        }
                        try {
                            Thread.sleep(50L);
                            break;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            Log.d((String)this.TAG, (String)"About to exit");
            OpenCvViewport.this.bitmapFromMat.recycle();
            OpenCvViewport.this.renderThreadAliveLock.unlock();
        }

        void drawOptimizingView(Canvas canvas) {
            OptimizedRotation optimizedViewRotationLocalCache = OpenCvViewport.this.optimizedViewRotation;
            if (optimizedViewRotationLocalCache == OptimizedRotation.NONE) {
                this.drawOptimizingEfficiency(canvas);
                return;
            }
            if (optimizedViewRotationLocalCache == OptimizedRotation.ROT_180) {
                canvas.rotate((float)optimizedViewRotationLocalCache.val, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
                this.drawOptimizingEfficiency(canvas);
                return;
            }
            this.drawOptimizingViewForQuarterRot(canvas, optimizedViewRotationLocalCache);
        }

        void drawOptimizingViewForQuarterRot(Canvas canvas, OptimizedRotation optimizedViewRotationLocalCache) {
            canvas.rotate((float)optimizedViewRotationLocalCache.val, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
            int origin_x = (canvas.getWidth() - canvas.getHeight()) / 2;
            int origin_y = (canvas.getHeight() - canvas.getWidth()) / 2;
            double canvasAspect = (float)canvas.getHeight() / (float)canvas.getWidth();
            if (OpenCvViewport.this.aspectRatio > canvasAspect) {
                canvas.drawBitmap(OpenCvViewport.this.bitmapFromMat, null, OpenCvViewport.this.createRect(origin_x, origin_y, canvas.getHeight(), (int)Math.round((double)canvas.getHeight() / OpenCvViewport.this.aspectRatio)), null);
            } else {
                canvas.drawBitmap(OpenCvViewport.this.bitmapFromMat, null, OpenCvViewport.this.createRect(origin_x, origin_y, (int)Math.round((double)canvas.getWidth() * OpenCvViewport.this.aspectRatio), canvas.getWidth()), null);
            }
            if (!OpenCvViewport.this.fpsMeterEnabled) {
                return;
            }
            int statBoxW = 450;
            int statBoxH = 120;
            Rect rect = null;
            if (optimizedViewRotationLocalCache == OptimizedRotation.ROT_90_COUNTERCLOCWISE) {
                rect = OpenCvViewport.this.createRect(origin_x + canvas.getHeight() - statBoxW, origin_y + canvas.getWidth() - statBoxH, statBoxW, statBoxH);
            } else if (optimizedViewRotationLocalCache == OptimizedRotation.ROT_90_CLOCKWISE) {
                rect = OpenCvViewport.this.createRect(origin_x + statBoxW - statBoxW, origin_y + canvas.getWidth() - statBoxH, statBoxW, statBoxH);
            }
            canvas.drawRect(rect, OpenCvViewport.this.fpsMeterBgPaint);
            int statBoxLTxtMargin = 5;
            int statBoxLTxtStart = rect.left + statBoxLTxtMargin;
            int textLineSpacing = 35;
            int textLine1Y = rect.bottom - 80;
            int textLine2Y = textLine1Y + textLineSpacing;
            int textLine3Y = textLine2Y + textLineSpacing;
            canvas.drawText("OpenFTC EasyOpenCV v1.4.1", (float)statBoxLTxtStart, (float)textLine1Y, OpenCvViewport.this.fpsMeterTextPaint);
            canvas.drawText(OpenCvViewport.this.getFpsString(), (float)statBoxLTxtStart, (float)textLine2Y, OpenCvViewport.this.fpsMeterTextPaint);
            canvas.drawText("Pipeline: " + OpenCvViewport.this.pipelineMs + "ms - Overhead: " + OpenCvViewport.this.overheadMs + "ms", (float)statBoxLTxtStart, (float)textLine3Y, OpenCvViewport.this.fpsMeterTextPaint);
        }

        void drawOptimizingEfficiency(Canvas canvas) {
            if ((double)canvas.getHeight() * OpenCvViewport.this.aspectRatio < (double)canvas.getWidth()) {
                canvas.drawBitmap(OpenCvViewport.this.bitmapFromMat, new Rect(0, 0, OpenCvViewport.this.bitmapFromMat.getWidth(), OpenCvViewport.this.bitmapFromMat.getHeight()), new Rect(0, 0, (int)Math.round((double)canvas.getHeight() * OpenCvViewport.this.aspectRatio), canvas.getHeight()), null);
            } else {
                canvas.drawBitmap(OpenCvViewport.this.bitmapFromMat, new Rect(0, 0, OpenCvViewport.this.bitmapFromMat.getWidth(), OpenCvViewport.this.bitmapFromMat.getHeight()), new Rect(0, 0, canvas.getWidth(), (int)Math.round((double)canvas.getWidth() / OpenCvViewport.this.aspectRatio)), null);
            }
            if (!OpenCvViewport.this.fpsMeterEnabled) {
                return;
            }
            canvas.drawRect(0.0f, (float)(canvas.getHeight() - 120), 450.0f, (float)canvas.getHeight(), OpenCvViewport.this.fpsMeterBgPaint);
            canvas.drawText("OpenFTC EasyOpenCV v1.4.1", 5.0f, (float)(canvas.getHeight() - 80), OpenCvViewport.this.fpsMeterTextPaint);
            canvas.drawText(OpenCvViewport.this.getFpsString(), 5.0f, (float)(canvas.getHeight() - 45), OpenCvViewport.this.fpsMeterTextPaint);
            canvas.drawText("Pipeline: " + OpenCvViewport.this.pipelineMs + "ms - Overhead: " + OpenCvViewport.this.overheadMs + "ms", 5.0f, (float)(canvas.getHeight() - 10), OpenCvViewport.this.fpsMeterTextPaint);
        }
    }

    public static enum OptimizedRotation {
        NONE(0),
        ROT_90_COUNTERCLOCWISE(90),
        ROT_90_CLOCKWISE(-90),
        ROT_180(180);

        int val;

        private OptimizedRotation(int val) {
            this.val = val;
        }
    }

    private static enum RenderingState {
        STOPPED,
        ACTIVE,
        PAUSED;

    }
}

