/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import java.util.ArrayList;
import org.opencv.core.Mat;
import org.openftc.easyopencv.OpenCvPipeline;
import org.openftc.easyopencv.OpenCvTracker;

public class OpenCvTrackerApiPipeline
extends OpenCvPipeline {
    private ArrayList<OpenCvTracker> trackers = new ArrayList();
    private int trackerDisplayIdx = 0;

    public synchronized void addTracker(OpenCvTracker tracker) {
        this.trackers.add(tracker);
    }

    public synchronized void removeTracker(OpenCvTracker tracker) {
        this.trackers.remove(tracker);
        if (this.trackerDisplayIdx >= this.trackers.size()) {
            --this.trackerDisplayIdx;
            if (this.trackerDisplayIdx < 0) {
                this.trackerDisplayIdx = 0;
            }
        }
    }

    @Override
    public synchronized Mat processFrame(Mat input) {
        if (this.trackers.size() == 0) {
            return input;
        }
        ArrayList<Mat> returnMats = new ArrayList<Mat>(this.trackers.size());
        for (OpenCvTracker tracker : this.trackers) {
            returnMats.add(tracker.processFrameInternal(input));
        }
        return (Mat)returnMats.get(this.trackerDisplayIdx);
    }

    @Override
    public synchronized void onViewportTapped() {
        ++this.trackerDisplayIdx;
        if (this.trackerDisplayIdx >= this.trackers.size()) {
            this.trackerDisplayIdx = 0;
        }
    }
}

