/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.os.Debug;
import java.io.File;
import java.util.concurrent.Semaphore;
import org.opencv.core.Mat;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;

public abstract class OpenCvPipeline {
    private boolean isFirstFrame = true;
    private static final Semaphore saveSemaphore = new Semaphore(5);
    private static final String savePath = "/sdcard/EasyOpenCV";
    private long firstFrameTimestamp;
    protected boolean MEMLEAK_DETECTION_ENABLED = true;
    protected int MEMLEAK_THRESHOLD_MB = 100;
    protected int MEMLEAK_DETECTION_PIPELINE_SETTLE_DELAY_SECONDS = 4;
    private long nativeAllocFirstMonitoredFrame;
    private boolean settled = false;
    private long currentAlloc;
    private long firstMonitoredFrameTimestamp;
    private String leakMsg = "";
    private long previousAbsoluteDeltaAlloc = Integer.MIN_VALUE;
    private double gcLeakOffsetMb;
    private int gcRuns = 0;
    private String lastLeakMsg = "";
    private long lastLeakMsgUpdateTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenCvPipeline() {
        Semaphore semaphore = saveSemaphore;
        synchronized (semaphore) {
            File saveDir = new File(savePath);
            if (!saveDir.exists()) {
                saveDir.mkdir();
            }
        }
    }

    Mat processFrameInternal(Mat input) {
        if (this.isFirstFrame) {
            this.init(input);
            this.firstFrameTimestamp = System.currentTimeMillis();
            this.isFirstFrame = false;
        }
        Mat ret = this.processFrame(input);
        this.leakDetection();
        return ret;
    }

    private void leakDetection() {
        double previousAbsoluteDeltaAllocMB;
        double absoluteDeltaAllocMB;
        if (!this.MEMLEAK_DETECTION_ENABLED) {
            return;
        }
        this.currentAlloc = Debug.getNativeHeapAllocatedSize();
        if (!this.settled && System.currentTimeMillis() - this.firstFrameTimestamp < (long)(this.MEMLEAK_DETECTION_PIPELINE_SETTLE_DELAY_SECONDS * 1000)) {
            this.settled = true;
            this.nativeAllocFirstMonitoredFrame = Debug.getNativeHeapAllocatedSize();
            this.firstMonitoredFrameTimestamp = System.currentTimeMillis();
            return;
        }
        if (!this.settled) {
            return;
        }
        long absoluteDeltaAlloc = this.currentAlloc - this.nativeAllocFirstMonitoredFrame;
        if (this.previousAbsoluteDeltaAlloc == Integer.MIN_VALUE) {
            this.previousAbsoluteDeltaAlloc = absoluteDeltaAlloc;
        }
        if ((absoluteDeltaAllocMB = (double)absoluteDeltaAlloc / 1048576.0) - (previousAbsoluteDeltaAllocMB = (double)this.previousAbsoluteDeltaAlloc / 1048576.0) < -20.0) {
            System.out.println("GC probably ran");
            this.gcLeakOffsetMb += previousAbsoluteDeltaAllocMB;
            ++this.gcRuns;
        }
        this.previousAbsoluteDeltaAlloc = absoluteDeltaAlloc;
        double timeSinceStartedMonitoring = (double)(System.currentTimeMillis() - this.firstMonitoredFrameTimestamp) / 1000.0;
        double leakRate = (absoluteDeltaAllocMB + this.gcLeakOffsetMb) / timeSinceStartedMonitoring;
        this.leakMsg = absoluteDeltaAllocMB + this.gcLeakOffsetMb > (double)this.MEMLEAK_THRESHOLD_MB ? String.format("Pipeline likely leaking memory @ %dMB/sec; total of %dMB leaked; GC likely run %d times", (int)leakRate, (int)(absoluteDeltaAllocMB + this.gcLeakOffsetMb), this.gcRuns) : "";
    }

    String getLeakMsg() {
        if (System.currentTimeMillis() - this.lastLeakMsgUpdateTime > 250L) {
            this.lastLeakMsgUpdateTime = System.currentTimeMillis();
            this.lastLeakMsg = this.leakMsg;
        }
        return this.lastLeakMsg;
    }

    public abstract Mat processFrame(Mat var1);

    public void onViewportTapped() {
    }

    public void init(Mat mat) {
    }

    public void saveMatToDisk(Mat mat, final String filename) {
        try {
            saveSemaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
        final Mat clone = mat.clone();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Imgproc.cvtColor((Mat)clone, (Mat)clone, (int)4);
                    Imgcodecs.imwrite((String)String.format("%s/%s.png", OpenCvPipeline.savePath, filename), (Mat)clone);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    clone.release();
                    saveSemaphore.release();
                }
            }
        }).start();
    }
}

