/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.annotation.SuppressLint;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.util.Range;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;
import org.openftc.easyopencv.FixedHandlerThread;
import org.openftc.easyopencv.OpenCvCamera;
import org.openftc.easyopencv.OpenCvCameraBase;
import org.openftc.easyopencv.OpenCvCameraException;
import org.openftc.easyopencv.OpenCvCameraRotation;
import org.openftc.easyopencv.OpenCvInternalCamera2;

@SuppressLint(value={"NewApi", "MissingPermission"})
public class OpenCvInternalCamera2Impl
extends OpenCvCameraBase
implements OpenCvInternalCamera2,
ImageReader.OnImageAvailableListener {
    CameraDevice mCameraDevice;
    FixedHandlerThread cameraHardwareHandlerThread;
    private Handler cameraHardwareHandler;
    FixedHandlerThread frameWorkerHandlerThread;
    Handler frameWorkerHandler;
    volatile CountDownLatch cameraOpenedLatch;
    volatile CountDownLatch streamingStartedLatch;
    ImageReader imageReader;
    CaptureRequest.Builder mPreviewRequestBuilder;
    CameraCaptureSession cameraCaptureSession;
    Mat rgbMat;
    OpenCvInternalCamera2.CameraDirection direction;
    private volatile boolean isOpen = false;
    public float exposureTime = 0.02f;
    private volatile boolean isStreaming = false;
    Surface surface;
    CameraManager cameraManager;
    CameraCharacteristics cameraCharacteristics;
    ReentrantLock sync = new ReentrantLock();
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            OpenCvInternalCamera2Impl.this.mCameraDevice = cameraDevice;
            OpenCvInternalCamera2Impl.this.cameraOpenedLatch.countDown();
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            OpenCvInternalCamera2Impl.this.mCameraDevice = null;
        }

        public void onError(CameraDevice cameraDevice, int error) {
            cameraDevice.close();
            OpenCvInternalCamera2Impl.this.mCameraDevice = null;
            OpenCvInternalCamera2Impl.this.cameraOpenedLatch.countDown();
        }
    };

    @SuppressLint(value={"WrongConstant"})
    public OpenCvInternalCamera2Impl(OpenCvInternalCamera2.CameraDirection direction) {
        this.direction = direction;
        this.cameraManager = (CameraManager)AppUtil.getInstance().getActivity().getSystemService("camera");
    }

    @SuppressLint(value={"WrongConstant"})
    public OpenCvInternalCamera2Impl(OpenCvInternalCamera2.CameraDirection direction, int containerLayoutId) {
        super(containerLayoutId);
        this.direction = direction;
        this.cameraManager = (CameraManager)AppUtil.getInstance().getActivity().getSystemService("camera");
    }

    @Override
    protected OpenCvCameraRotation getDefaultRotation() {
        return OpenCvCameraRotation.UPRIGHT;
    }

    @Override
    protected int mapRotationEnumToOpenCvRotateCode(OpenCvCameraRotation rotation) {
        if (this.direction == OpenCvInternalCamera2.CameraDirection.BACK) {
            if (rotation == OpenCvCameraRotation.UPRIGHT) {
                return 0;
            }
            if (rotation == OpenCvCameraRotation.UPSIDE_DOWN) {
                return 2;
            }
            if (rotation == OpenCvCameraRotation.SIDEWAYS_RIGHT) {
                return 1;
            }
            return -1;
        }
        if (rotation == OpenCvCameraRotation.UPRIGHT) {
            return 2;
        }
        if (rotation == OpenCvCameraRotation.UPSIDE_DOWN) {
            return 0;
        }
        if (rotation == OpenCvCameraRotation.SIDEWAYS_RIGHT) {
            return 1;
        }
        return -1;
    }

    @Override
    protected boolean cameraOrientationIsTiedToDeviceOrientation() {
        return true;
    }

    @Override
    public void openCameraDevice() {
        this.sync.lock();
        if (this.hasBeenCleanedUp()) {
            return;
        }
        if (!this.isOpen && this.mCameraDevice == null) {
            try {
                this.startCameraHardwareHandlerThread();
                String[] camList = this.cameraManager.getCameraIdList();
                String camId = null;
                for (String s : camList) {
                    if ((Integer)this.cameraManager.getCameraCharacteristics(s).get(CameraCharacteristics.LENS_FACING) != this.direction.id) continue;
                    camId = s;
                    break;
                }
                this.cameraOpenedLatch = new CountDownLatch(1);
                this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics(camId);
                this.cameraManager.openCamera(camId, this.mStateCallback, this.cameraHardwareHandler);
                this.cameraOpenedLatch.await();
                this.isOpen = true;
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        this.sync.unlock();
    }

    @Override
    public void openCameraDeviceAsync(final OpenCvCamera.AsyncCameraOpenListener asyncCameraOpenListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OpenCvInternalCamera2Impl.this.sync.lock();
                try {
                    OpenCvInternalCamera2Impl.this.openCameraDevice();
                    asyncCameraOpenListener.onOpened();
                }
                catch (Exception e) {
                    if (!OpenCvInternalCamera2Impl.this.hasBeenCleanedUp()) {
                        OpenCvInternalCamera2Impl.this.emulateEStop(e);
                    } else {
                        e.printStackTrace();
                    }
                }
                finally {
                    OpenCvInternalCamera2Impl.this.sync.unlock();
                }
            }
        }).start();
    }

    @Override
    public void closeCameraDevice() {
        this.sync.lock();
        this.cleanupForClosingCamera();
        if (this.isOpen) {
            if (this.mCameraDevice != null) {
                this.stopStreaming();
                this.mCameraDevice.close();
                this.stopCameraHardwareHandlerThread();
                this.mCameraDevice = null;
            }
            this.isOpen = false;
        }
        this.sync.unlock();
    }

    @Override
    public void closeCameraDeviceAsync(final OpenCvCamera.AsyncCameraCloseListener asyncCameraCloseListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OpenCvInternalCamera2Impl.this.sync.lock();
                try {
                    OpenCvInternalCamera2Impl.this.closeCameraDevice();
                    asyncCameraCloseListener.onClose();
                }
                catch (Exception e) {
                    if (!OpenCvInternalCamera2Impl.this.hasBeenCleanedUp()) {
                        OpenCvInternalCamera2Impl.this.emulateEStop(e);
                    } else {
                        e.printStackTrace();
                    }
                }
                finally {
                    OpenCvInternalCamera2Impl.this.sync.unlock();
                }
            }
        }).start();
    }

    @Override
    public void startStreaming(int width, int height) {
        this.startStreaming(width, height, OpenCvCameraRotation.UPRIGHT);
    }

    @Override
    public void startStreaming(int width, int height, OpenCvCameraRotation rotation) {
        this.sync.lock();
        if (this.isStreaming) {
            this.stopStreaming();
        }
        this.prepareForStartStreaming(width, height, rotation);
        try {
            this.rgbMat = new Mat(height, width, CvType.CV_8UC3);
            this.startFrameWorkerHandlerThread();
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            this.imageReader = ImageReader.newInstance((int)width, (int)height, (int)35, (int)2);
            this.imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, this.frameWorkerHandler);
            this.surface = this.imageReader.getSurface();
            this.mPreviewRequestBuilder.addTarget(this.surface);
            this.streamingStartedLatch = new CountDownLatch(1);
            CameraCaptureSession.StateCallback callback = new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession session) {
                    try {
                        if (null == OpenCvInternalCamera2Impl.this.mCameraDevice) {
                            return;
                        }
                        OpenCvInternalCamera2Impl.this.cameraCaptureSession = session;
                        OpenCvInternalCamera2Impl.this.cameraCaptureSession.setRepeatingRequest(OpenCvInternalCamera2Impl.this.mPreviewRequestBuilder.build(), null, OpenCvInternalCamera2Impl.this.cameraHardwareHandler);
                    }
                    catch (CameraAccessException e) {
                        e.printStackTrace();
                    }
                    finally {
                        OpenCvInternalCamera2Impl.this.streamingStartedLatch.countDown();
                    }
                }

                public void onConfigureFailed(CameraCaptureSession session) {
                }
            };
            this.mCameraDevice.createCaptureSession(Arrays.asList(this.surface), callback, this.cameraHardwareHandler);
            this.streamingStartedLatch.await();
            this.isStreaming = true;
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        this.sync.unlock();
    }

    @Override
    public void stopStreaming() {
        this.sync.lock();
        this.cleanupForEndStreaming();
        try {
            if (null != this.cameraCaptureSession) {
                this.cameraCaptureSession.close();
                this.cameraCaptureSession = null;
                this.isStreaming = false;
            }
        }
        finally {
            if (null != this.imageReader) {
                this.imageReader.close();
                this.imageReader = null;
                this.stopFrameWorkerHandlerThread();
            }
            this.sync.unlock();
        }
    }

    private void onPreviewFrame(Image image) {
        this.notifyStartOfFrameProcessing();
        int w = image.getWidth();
        int h = image.getHeight();
        Image.Plane[] planes = image.getPlanes();
        ByteBuffer y_plane = planes[0].getBuffer();
        ByteBuffer uv_plane1 = planes[1].getBuffer();
        ByteBuffer uv_plane2 = planes[2].getBuffer();
        Mat y_mat = new Mat(h, w, CvType.CV_8UC1, y_plane);
        Mat uv_mat1 = new Mat(h / 2, w / 2, CvType.CV_8UC2, uv_plane1);
        Mat uv_mat2 = new Mat(h / 2, w / 2, CvType.CV_8UC2, uv_plane2);
        long addr_diff = uv_mat2.dataAddr() - uv_mat1.dataAddr();
        if (addr_diff > 0L) {
            Imgproc.cvtColorTwoPlane((Mat)y_mat, (Mat)uv_mat1, (Mat)this.rgbMat, (int)94);
        } else {
            Imgproc.cvtColorTwoPlane((Mat)y_mat, (Mat)uv_mat2, (Mat)this.rgbMat, (int)96);
        }
        y_mat.release();
        uv_mat1.release();
        uv_mat2.release();
        image.close();
        this.handleFrame(this.rgbMat);
    }

    private void startFrameWorkerHandlerThread() {
        this.sync.lock();
        this.frameWorkerHandlerThread = new FixedHandlerThread("FrameWorkerHandlerThread");
        this.frameWorkerHandlerThread.start();
        this.frameWorkerHandler = new Handler(this.frameWorkerHandlerThread.getLooper());
        this.sync.unlock();
    }

    private void stopFrameWorkerHandlerThread() {
        this.sync.lock();
        if (this.frameWorkerHandlerThread != null) {
            this.frameWorkerHandlerThread.quit();
            this.frameWorkerHandlerThread.interrupt();
            this.joinUninterruptibly(this.frameWorkerHandlerThread);
            this.frameWorkerHandlerThread = null;
            this.frameWorkerHandler = null;
        }
        this.sync.unlock();
    }

    private void startCameraHardwareHandlerThread() {
        this.sync.lock();
        this.cameraHardwareHandlerThread = new FixedHandlerThread("CameraHardwareHandlerThread");
        this.cameraHardwareHandlerThread.start();
        this.cameraHardwareHandler = new Handler(this.cameraHardwareHandlerThread.getLooper());
        this.sync.unlock();
    }

    private void stopCameraHardwareHandlerThread() {
        this.sync.lock();
        if (this.cameraHardwareHandlerThread == null) {
            return;
        }
        this.cameraHardwareHandlerThread.quitSafely();
        this.cameraHardwareHandlerThread.interrupt();
        this.joinUninterruptibly(this.cameraHardwareHandlerThread);
        this.cameraHardwareHandlerThread = null;
        this.cameraHardwareHandler = null;
        this.sync.unlock();
    }

    public void onImageAvailable(ImageReader reader) {
        try {
            this.sync.lockInterruptibly();
            Image image = reader.acquireLatestImage();
            if (image != null) {
                try {
                    this.onPreviewFrame(image);
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
                image.close();
            }
            this.sync.unlock();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    private void joinUninterruptibly(Thread thread) {
        boolean interrupted = false;
        while (true) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public int getMinSensorGain() {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("getMinSensorGain() called, but camera is not opened!");
            }
            int n = (Integer)((Range)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_SENSITIVITY_RANGE)).getLower();
            return n;
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public int getMaxSensorGain() {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("getMinSensorGain() called, but camera is not opened!");
            }
            int n = (Integer)((Range)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_SENSITIVITY_RANGE)).getUpper();
            return n;
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void setSensorGain(int iso) {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("setSensorGain() called, but camera is not opened!");
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.SENSOR_SENSITIVITY, (Object)iso);
            this.apply();
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void setWhiteBalanceMode(OpenCvInternalCamera2.WhiteBalanceMode whiteBalanceMode) {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("setWhiteBalanceMode() called, but camera is not opened!");
            }
            switch (whiteBalanceMode) {
                case AUTO: {
                    this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)1);
                    break;
                }
                case MANUAL: {
                    this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)0);
                    break;
                }
                case SHADE: {
                    this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)8);
                    break;
                }
                case DAYLIGHT: {
                    this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)5);
                    break;
                }
                case TWILIGHT: {
                    this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)7);
                    break;
                }
                case FLUORESCENT: {
                    this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)3);
                    break;
                }
                case INCANDESCENT: {
                    this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)2);
                    break;
                }
                case CLOUDY_DAYLIGHT: {
                    this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)6);
                    break;
                }
                case WARM_FLUORESCENT: {
                    this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)4);
                }
            }
            this.apply();
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void setAutoWhiteBalanceLocked(boolean locked) {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("setAutoWhiteBalanceLocked() called, but camera is not opened!");
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AWB_LOCK, (Object)locked);
            this.apply();
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void setExposureMode(OpenCvInternalCamera2.ExposureMode exposureMode) {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("setExposureMode() called, but camera is not opened!");
            }
            if (exposureMode == OpenCvInternalCamera2.ExposureMode.MANUAL) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)0);
            } else if (exposureMode == OpenCvInternalCamera2.ExposureMode.AUTO) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            }
            this.apply();
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void setAutoExposureLocked(boolean locked) {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("setAutoExposureLocked() called, but camera is not opened!");
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)locked);
            this.apply();
        }
        finally {
            this.sync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSensorFps(int sensorFps) {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("setSensorFps() called, but camera is not opened!");
            }
            long nanos = (long)(1.0 / (double)sensorFps * 1.0E9);
            this.mPreviewRequestBuilder.set(CaptureRequest.SENSOR_FRAME_DURATION, (Object)nanos);
            this.apply();
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void setFlashlightEnabled(boolean enabled) {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("setSensorFps() called, but camera is not opened!");
            }
            if (enabled) {
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
            } else {
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
            this.apply();
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public int getMinAutoExposureCompensation() {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("getMinAutoExposureCompensation() called, but camera is not opened!");
            }
            int n = (Integer)((Range)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE)).getLower();
            return n;
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public int getMaxAutoExposureCompensation() {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("getMaxAutoExposureCompensation() called, but camera is not opened!");
            }
            int n = (Integer)((Range)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE)).getUpper();
            return n;
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void setAutoExposureCompensation(int aeCompensation) {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("setAutoExposureCompensation() called, but camera is not opened!");
            }
            if (aeCompensation < this.getMinAutoExposureCompensation()) {
                throw new OpenCvCameraException("Auto exposure compensation must be >= the value returned by getMinAutoExposureCompensation()");
            }
            if (aeCompensation > this.getMaxAutoExposureCompensation()) {
                throw new OpenCvCameraException("Auto exposure compensation must be <= the value returned by getMaxAutoExposureCompensation()");
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)aeCompensation);
            this.apply();
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void setExposureFractional(int denominator) {
        double exposureTimeSeconds = 1.0 / (double)denominator;
        long exposureTimeNanos = (long)(exposureTimeSeconds * 1.0E9);
        this.setExposureNanos(exposureTimeNanos);
    }

    @Override
    public void setExposureNanos(long nanos) {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("setExposureNanos() called, but camera is not opened!");
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.SENSOR_EXPOSURE_TIME, (Object)nanos);
            this.apply();
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void setFocusMode(OpenCvInternalCamera2.FocusMode focusMode) {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("setFocusMode() called, but camera is not opened!");
            }
            if (focusMode == OpenCvInternalCamera2.FocusMode.MANUAL) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            } else if (focusMode == OpenCvInternalCamera2.FocusMode.CONTINUOUS_AUTO_PICTURE) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            } else if (focusMode == OpenCvInternalCamera2.FocusMode.CONTINUOUS_AUTO_VIDEO) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            }
            this.apply();
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public float getMinFocusDistance() {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new OpenCvCameraException("getMinFocusDistance() called, but camera is not opened!");
            }
            float f = ((Float)this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE)).floatValue();
            return f;
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void setFocusDistance(float diopters) {
        this.sync.lock();
        try {
            if (this.mCameraDevice == null) {
                throw new RuntimeException("setFocusDistance() called, but camera is not opened!");
            }
            if ((double)diopters < 0.0) {
                throw new RuntimeException("Focus distance must be >= 0.0!");
            }
            if (diopters > this.getMinFocusDistance()) {
                throw new RuntimeException("Focus distance must be <= the value returned by getMinFocusDistance()");
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(diopters));
            this.apply();
        }
        finally {
            this.sync.unlock();
        }
    }

    private void apply() {
        try {
            this.cameraCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), null, this.cameraHardwareHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }
}

