/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.content.Context;
import android.support.annotation.IdRes;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.qualcomm.robotcore.eventloop.opmode.AnnotatedOpModeManager;
import com.qualcomm.robotcore.eventloop.opmode.OpMode;
import com.qualcomm.robotcore.eventloop.opmode.OpModeRegistrar;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.firstinspires.ftc.robotcore.external.ClassFactory;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraName;
import org.firstinspires.ftc.robotcore.external.hardware.camera.WebcamName;
import org.firstinspires.ftc.robotcore.internal.camera.delegating.SwitchableCameraName;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.openftc.easyopencv.LIFO_OpModeCallbackDelegate;
import org.openftc.easyopencv.OpenCvCameraException;
import org.openftc.easyopencv.OpenCvCameraFactory;
import org.openftc.easyopencv.OpenCvInternalCamera;
import org.openftc.easyopencv.OpenCvInternalCamera2;
import org.openftc.easyopencv.OpenCvInternalCamera2Impl;
import org.openftc.easyopencv.OpenCvInternalCameraImpl;
import org.openftc.easyopencv.OpenCvSwitchableWebcam;
import org.openftc.easyopencv.OpenCvSwitchableWebcamImpl;
import org.openftc.easyopencv.OpenCvWebcam;
import org.openftc.easyopencv.OpenCvWebcamImpl;

class OpenCvCameraFactoryImpl
extends OpenCvCameraFactory {
    OpenCvCameraFactoryImpl() {
    }

    static void init() {
        OpenCvCameraFactory.theInstance = new OpenCvCameraFactoryImpl();
    }

    @OpModeRegistrar
    public static void initOnSdkBoot(Context context, AnnotatedOpModeManager manager) {
        OpenCvCameraFactoryImpl.init();
    }

    @Override
    public OpenCvInternalCamera createInternalCamera(OpenCvInternalCamera.CameraDirection direction) {
        return new OpenCvInternalCameraImpl(direction);
    }

    @Override
    public OpenCvInternalCamera createInternalCamera(OpenCvInternalCamera.CameraDirection direction, int containerId) {
        return new OpenCvInternalCameraImpl(direction, containerId);
    }

    @Override
    public OpenCvInternalCamera2 createInternalCamera2(OpenCvInternalCamera2.CameraDirection direction) {
        return new OpenCvInternalCamera2Impl(direction);
    }

    @Override
    public OpenCvInternalCamera2 createInternalCamera2(OpenCvInternalCamera2.CameraDirection direction, int containerId) {
        return new OpenCvInternalCamera2Impl(direction, containerId);
    }

    @Override
    public OpenCvWebcam createWebcam(WebcamName webcamName) {
        return new OpenCvWebcamImpl((CameraName)webcamName);
    }

    @Override
    public OpenCvWebcam createWebcam(WebcamName webcamName, @IdRes int viewportContainerId) {
        return new OpenCvWebcamImpl((CameraName)webcamName, viewportContainerId);
    }

    @Override
    public OpenCvSwitchableWebcam createSwitchableWebcam(WebcamName ... names) {
        SwitchableCameraName cameraName = ClassFactory.getInstance().getCameraManager().nameForSwitchableCamera((CameraName[])names);
        return new OpenCvSwitchableWebcamImpl(cameraName);
    }

    @Override
    public OpenCvSwitchableWebcam createSwitchableWebcam(int viewportContainerId, WebcamName ... names) {
        SwitchableCameraName cameraName = ClassFactory.getInstance().getCameraManager().nameForSwitchableCamera((CameraName[])names);
        return new OpenCvSwitchableWebcamImpl(cameraName, viewportContainerId);
    }

    @Override
    public int[] splitLayoutForMultipleViewports(final int containerId, final int numViewports, final OpenCvCameraFactory.ViewportSplitMethod viewportSplitMethod) {
        if (numViewports < 2) {
            throw new IllegalArgumentException("Layout requested to be split for <2 viewports!");
        }
        final int[] ids = new int[numViewports];
        final ArrayList layoutArrayList = new ArrayList(numViewports);
        final CountDownLatch latch = new CountDownLatch(1);
        final RuntimeException[] exToRethrowOnOpModeThread = new RuntimeException[]{null};
        AppUtil.getInstance().getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    final LinearLayout containerLayout = (LinearLayout)AppUtil.getInstance().getActivity().findViewById(containerId);
                    if (containerLayout == null) {
                        throw new OpenCvCameraException("Viewport container specified by user does not exist!");
                    }
                    if (containerLayout.getChildCount() != 0) {
                        throw new OpenCvCameraException("Viewport container specified by user is not empty!");
                    }
                    containerLayout.setVisibility(0);
                    if (viewportSplitMethod == null) {
                        throw new IllegalArgumentException("Viewport split method cannot be null!");
                    }
                    if (viewportSplitMethod == OpenCvCameraFactory.ViewportSplitMethod.VERTICALLY) {
                        containerLayout.setOrientation(1);
                    } else {
                        containerLayout.setOrientation(0);
                    }
                    for (int i = 0; i < numViewports; ++i) {
                        LinearLayout linearLayout = new LinearLayout((Context)AppUtil.getInstance().getActivity());
                        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
                        params.weight = 1.0f;
                        linearLayout.setLayoutParams((ViewGroup.LayoutParams)params);
                        linearLayout.setId(View.generateViewId());
                        ids[i] = linearLayout.getId();
                        layoutArrayList.add(linearLayout);
                        containerLayout.addView((View)linearLayout);
                    }
                    LIFO_OpModeCallbackDelegate.getInstance().add(new LIFO_OpModeCallbackDelegate.OnOpModeStoppedListener(){

                        @Override
                        public void onOpModePostStop(OpMode opMode) {
                            AppUtil.getInstance().getActivity().runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (LinearLayout layout : layoutArrayList) {
                                        containerLayout.removeView((View)layout);
                                    }
                                    containerLayout.setVisibility(8);
                                    containerLayout.setOrientation(1);
                                }
                            });
                        }
                    });
                    latch.countDown();
                }
                catch (RuntimeException e) {
                    exToRethrowOnOpModeThread[0] = e;
                }
            }
        });
        if (exToRethrowOnOpModeThread[0] != null) {
            throw exToRethrowOnOpModeThread[0];
        }
        try {
            latch.await();
            return ids;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

