/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.app.Activity;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.qualcomm.robotcore.eventloop.EventLoopManager;
import com.qualcomm.robotcore.eventloop.opmode.OpMode;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerNotifier;
import com.qualcomm.robotcore.robot.RobotState;
import com.qualcomm.robotcore.util.ElapsedTime;
import com.qualcomm.robotcore.util.GlobalWarningSource;
import com.qualcomm.robotcore.util.MovingStatistics;
import com.qualcomm.robotcore.util.RobotLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.firstinspires.ftc.robotcore.external.android.util.Size;
import org.firstinspires.ftc.robotcore.external.function.Consumer;
import org.firstinspires.ftc.robotcore.external.function.Continuation;
import org.firstinspires.ftc.robotcore.external.function.ContinuationResult;
import org.firstinspires.ftc.robotcore.external.stream.CameraStreamServer;
import org.firstinspires.ftc.robotcore.external.stream.CameraStreamSource;
import org.firstinspires.ftc.robotcore.internal.opmode.OpModeManagerImpl;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.opencv.android.Utils;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import org.openftc.easyopencv.LIFO_OpModeCallbackDelegate;
import org.openftc.easyopencv.OpenCvCamera;
import org.openftc.easyopencv.OpenCvCameraException;
import org.openftc.easyopencv.OpenCvCameraRotation;
import org.openftc.easyopencv.OpenCvPipeline;
import org.openftc.easyopencv.OpenCvViewport;

public abstract class OpenCvCameraBase
implements OpenCvCamera,
CameraStreamSource,
GlobalWarningSource {
    private OpenCvPipeline pipeline = null;
    private LinearLayout viewportContainerLayout;
    private MovingStatistics msFrameIntervalRollingAverage;
    private MovingStatistics msUserPipelineRollingAverage;
    private MovingStatistics msTotalFrameProcessingTimeRollingAverage;
    private ElapsedTime timer;
    protected OpenCvViewport viewport;
    private OpenCvCameraRotation rotation;
    private int frameCount = 0;
    private float avgFps;
    private int avgPipelineTime;
    private int avgOverheadTime;
    private int avgTotalFrameTime;
    private long currentFrameStartTime;
    private final Object bitmapFrameLock = new Object();
    private Continuation<? extends Consumer<Bitmap>> bitmapContinuation;
    private Mat rotatedMat = new Mat();
    private Mat matToUseIfPipelineReturnedCropped;
    private Mat croppedColorCvtedMat = new Mat();
    private Scalar brown = new Scalar(82.0, 61.0, 46.0);
    private OpModeNotificationsForOrientation opModeNotificationsForOrientation = new OpModeNotificationsForOrientation();
    private ComponentCallbacksForRotation componentCallbacksForRotation = new ComponentCallbacksForRotation();
    private volatile boolean hasBeenCleanedUp = false;
    private final Object pipelineChangeLock = new Object();
    private OpModeNotifications opModeNotifications = new OpModeNotifications();

    public OpenCvCameraBase() {
        System.out.println("OpenCvCameraBase ctor: EasyOpenCV version 1.4.1");
        this.frameCount = 0;
        LIFO_OpModeCallbackDelegate.getInstance().add(this.opModeNotifications);
        RobotLog.registerGlobalWarningSource((GlobalWarningSource)this);
        CameraStreamServer.getInstance().setSource((CameraStreamSource)this);
    }

    public OpenCvCameraBase(int containerLayoutId) {
        this();
        this.setupViewport(containerLayoutId);
        AppUtil.getInstance().getApplication().registerComponentCallbacks((ComponentCallbacks)this.componentCallbacksForRotation);
        OpModeManagerImpl.getOpModeManagerOfActivity((Activity)AppUtil.getInstance().getActivity()).registerListener((OpModeManagerNotifier.Notifications)this.opModeNotificationsForOrientation);
    }

    public final synchronized void cleanupForClosingCamera() {
        if (this.viewport != null) {
            this.removeViewportAsync();
        }
    }

    public synchronized boolean hasBeenCleanedUp() {
        return this.hasBeenCleanedUp;
    }

    public final synchronized void prepareForStartStreaming(int width, int height, OpenCvCameraRotation rotation) {
        this.rotation = rotation;
        this.msFrameIntervalRollingAverage = new MovingStatistics(30);
        this.msUserPipelineRollingAverage = new MovingStatistics(30);
        this.msTotalFrameProcessingTimeRollingAverage = new MovingStatistics(30);
        this.timer = new ElapsedTime();
        if (this.viewport != null) {
            this.viewport.setSize(this.getFrameSizeAfterRotation(width, height, rotation));
            this.viewport.setOptimizedViewRotation(this.getOptimizedViewportRotation(rotation, AppUtil.getInstance().getActivity().getWindowManager().getDefaultDisplay().getRotation()));
            this.viewport.activate();
        }
    }

    public final synchronized void cleanupForEndStreaming() {
        this.matToUseIfPipelineReturnedCropped = null;
        if (this.viewport != null) {
            this.viewport.deactivate();
        }
    }

    @Override
    public final synchronized void pauseViewport() {
        if (this.viewport != null) {
            this.viewport.pause();
        }
    }

    @Override
    public final synchronized void resumeViewport() {
        if (this.viewport != null) {
            this.viewport.resume();
        }
    }

    @Override
    public final synchronized void showFpsMeterOnViewport(boolean show) {
        if (this.viewport != null) {
            this.viewport.setFpsMeterEnabled(show);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void setPipeline(OpenCvPipeline pipeline) {
        Object object = this.pipelineChangeLock;
        synchronized (object) {
            this.pipeline = pipeline;
        }
    }

    private void setupViewport(final int containerLayoutId) {
        final CountDownLatch latch = new CountDownLatch(1);
        final RuntimeException[] exToRethrowOnOpModeThread = new RuntimeException[]{null};
        AppUtil.getInstance().getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    OpenCvCameraBase.this.viewportContainerLayout = (LinearLayout)AppUtil.getInstance().getActivity().findViewById(containerLayoutId);
                    if (OpenCvCameraBase.this.viewportContainerLayout == null) {
                        throw new OpenCvCameraException("Viewport container specified by user does not exist!");
                    }
                    if (OpenCvCameraBase.this.viewportContainerLayout.getChildCount() != 0) {
                        throw new OpenCvCameraException("Viewport container specified by user is not empty!");
                    }
                    OpenCvCameraBase.this.viewport = new OpenCvViewport((Context)AppUtil.getInstance().getActivity(), new View.OnClickListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onClick(View view) {
                            OpenCvCameraBase openCvCameraBase = OpenCvCameraBase.this;
                            synchronized (openCvCameraBase) {
                                if (OpenCvCameraBase.this.pipeline != null) {
                                    OpenCvCameraBase.this.pipeline.onViewportTapped();
                                }
                            }
                        }
                    });
                    OpenCvCameraBase.this.viewport.setSize(new Size(320, 240));
                    OpenCvCameraBase.this.viewport.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                    OpenCvCameraBase.this.viewportContainerLayout.setVisibility(0);
                    OpenCvCameraBase.this.viewportContainerLayout.addView((View)OpenCvCameraBase.this.viewport);
                    latch.countDown();
                }
                catch (RuntimeException e) {
                    exToRethrowOnOpModeThread[0] = e;
                }
            }
        });
        if (exToRethrowOnOpModeThread[0] != null) {
            throw exToRethrowOnOpModeThread[0];
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
            this.viewport = null;
        }
    }

    private void removeViewportAsync() {
        AppUtil.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                OpenCvCameraBase.this.viewportContainerLayout.removeView((View)OpenCvCameraBase.this.viewport);
                OpenCvCameraBase.this.viewport = null;
                OpenCvCameraBase.this.viewportContainerLayout.setVisibility(8);
            }
        });
    }

    protected void notifyStartOfFrameProcessing() {
        this.currentFrameStartTime = System.currentTimeMillis();
    }

    protected synchronized void handleFrame(Mat frame) {
        try {
            this.handleFrameUserCrashable(frame);
        }
        catch (Exception e) {
            this.emulateEStop(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void handleFrameUserCrashable(Mat frame) {
        this.msFrameIntervalRollingAverage.add(this.timer.milliseconds());
        this.timer.reset();
        double secondsPerFrame = this.msFrameIntervalRollingAverage.getMean() / 1000.0;
        this.avgFps = (float)(1.0 / secondsPerFrame);
        Mat userProcessedFrame = null;
        int rotateCode = this.mapRotationEnumToOpenCvRotateCode(this.rotation);
        if (rotateCode != -1) {
            Core.rotate((Mat)frame, (Mat)this.rotatedMat, (int)rotateCode);
            frame = this.rotatedMat;
        }
        if (this.pipeline != null) {
            long pipelineStart = System.currentTimeMillis();
            userProcessedFrame = this.pipeline.processFrameInternal(frame);
            this.msUserPipelineRollingAverage.add((double)(System.currentTimeMillis() - pipelineStart));
        }
        if (this.viewport != null) {
            if (this.pipeline == null) {
                this.viewport.post(frame);
            } else {
                if (userProcessedFrame == null) {
                    throw new OpenCvCameraException("User pipeline returned null frame for viewport display");
                }
                if (userProcessedFrame.cols() != frame.cols() || userProcessedFrame.rows() != frame.rows()) {
                    if (userProcessedFrame.cols() > frame.cols() || userProcessedFrame.rows() > frame.rows()) {
                        throw new OpenCvCameraException("User pipeline returned frame of unexpected size");
                    }
                    if (this.matToUseIfPipelineReturnedCropped == null) {
                        this.matToUseIfPipelineReturnedCropped = frame.clone();
                    }
                    this.matToUseIfPipelineReturnedCropped.setTo(this.brown);
                    int usrFrmTyp = userProcessedFrame.type();
                    if (usrFrmTyp == CvType.CV_8UC1) {
                        Imgproc.cvtColor((Mat)userProcessedFrame, (Mat)this.croppedColorCvtedMat, (int)9);
                        userProcessedFrame = this.croppedColorCvtedMat;
                    } else if (usrFrmTyp != CvType.CV_8UC4 && usrFrmTyp != CvType.CV_8UC3) {
                        throw new OpenCvCameraException("User pipeline returned a frame of an illegal type. Valid types are CV_8UC1, CV_8UC3, and CV_8UC4");
                    }
                    userProcessedFrame.copyTo(this.matToUseIfPipelineReturnedCropped.submat(new Rect(0, 0, userProcessedFrame.cols(), userProcessedFrame.rows())));
                    this.viewport.post(this.matToUseIfPipelineReturnedCropped);
                } else {
                    this.viewport.post(userProcessedFrame);
                }
            }
        }
        this.avgPipelineTime = (int)Math.round(this.msUserPipelineRollingAverage.getMean());
        this.avgTotalFrameTime = (int)Math.round(this.msTotalFrameProcessingTimeRollingAverage.getMean());
        this.avgOverheadTime = this.avgTotalFrameTime - this.avgPipelineTime;
        if (this.viewport != null) {
            this.viewport.notifyStatistics(this.avgFps, this.avgPipelineTime, this.avgOverheadTime);
        }
        ++this.frameCount;
        this.msTotalFrameProcessingTimeRollingAverage.add((double)(System.currentTimeMillis() - this.currentFrameStartTime));
        Object object = this.bitmapFrameLock;
        synchronized (object) {
            if (this.bitmapContinuation != null) {
                Mat matToCvt = null;
                matToCvt = userProcessedFrame == null ? frame : userProcessedFrame;
                final Bitmap bitmapFromMat = Bitmap.createBitmap((int)matToCvt.cols(), (int)matToCvt.rows(), (Bitmap.Config)Bitmap.Config.RGB_565);
                Utils.matToBitmap((Mat)matToCvt, (Bitmap)bitmapFromMat);
                if (bitmapFromMat != null) {
                    this.bitmapContinuation.dispatch((ContinuationResult)new ContinuationResult<Consumer<Bitmap>>(){

                        public void handle(Consumer<Bitmap> bitmapConsumer) {
                            bitmapConsumer.accept((Object)bitmapFromMat);
                            bitmapFromMat.recycle();
                        }
                    });
                    this.bitmapContinuation = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFrameBitmap(Continuation<? extends Consumer<Bitmap>> continuation) {
        Object object = this.bitmapFrameLock;
        synchronized (object) {
            this.bitmapContinuation = continuation;
        }
    }

    protected void emulateEStop(Exception e) {
        RobotLog.ee((String)"OpenCvCamera", (Throwable)e, (String)"User code threw an uncaught exception");
        String errorMsg = e.getClass().getSimpleName() + (e.getMessage() != null ? " - " + e.getMessage() : "");
        RobotLog.setGlobalErrorMsg((String)("User code threw an uncaught exception: " + errorMsg));
        OpModeManagerImpl mgr = OpModeManagerImpl.getOpModeManagerOfActivity((Activity)AppUtil.getInstance().getActivity());
        mgr.initActiveOpMode("$Stop$Robot$");
        try {
            Field eventLoopMgrField = OpModeManagerImpl.class.getDeclaredField("eventLoopManager");
            eventLoopMgrField.setAccessible(true);
            EventLoopManager eventLoopManager = (EventLoopManager)eventLoopMgrField.get(mgr);
            Method changeStateMethod = EventLoopManager.class.getDeclaredMethod("changeState", RobotState.class);
            changeStateMethod.setAccessible(true);
            changeStateMethod.invoke((Object)eventLoopManager, RobotState.EMERGENCY_STOP);
            eventLoopManager.refreshSystemTelemetryNow();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public int getFrameCount() {
        return this.frameCount;
    }

    @Override
    public float getFps() {
        return this.avgFps;
    }

    @Override
    public int getPipelineTimeMs() {
        return this.avgPipelineTime;
    }

    @Override
    public int getOverheadTimeMs() {
        return this.avgOverheadTime;
    }

    @Override
    public int getTotalFrameTimeMs() {
        return this.avgTotalFrameTime;
    }

    @Override
    public int getCurrentPipelineMaxFps() {
        if (this.avgTotalFrameTime != 0) {
            return 1000 / this.avgTotalFrameTime;
        }
        return 0;
    }

    @Override
    public synchronized void setViewportRenderingPolicy(OpenCvCamera.ViewportRenderingPolicy policy) {
        if (this.viewport != null) {
            if (!this.cameraOrientationIsTiedToDeviceOrientation()) {
                throw new OpenCvCameraException("Setting viewport rendering policy is not applicable for this type of camera");
            }
            this.viewport.setRenderingPolicy(policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGlobalWarning() {
        Object object = this.pipelineChangeLock;
        synchronized (object) {
            if (this.pipeline != null) {
                return this.pipeline.getLeakMsg();
            }
            return "";
        }
    }

    public void suppressGlobalWarning(boolean suppress) {
    }

    public void setGlobalWarning(String warning) {
    }

    public void clearGlobalWarning() {
    }

    protected Size getFrameSizeAfterRotation(int width, int height, OpenCvCameraRotation rotation) {
        int screenRenderedHeight;
        int screenRenderedWidth;
        int openCvRotateCode = this.mapRotationEnumToOpenCvRotateCode(rotation);
        if (openCvRotateCode == 0 || openCvRotateCode == 2) {
            screenRenderedWidth = height;
            screenRenderedHeight = width;
        } else {
            screenRenderedWidth = width;
            screenRenderedHeight = height;
        }
        return new Size(screenRenderedWidth, screenRenderedHeight);
    }

    protected OpenCvViewport.OptimizedRotation getOptimizedViewportRotation(OpenCvCameraRotation streamRotation, int windowRotation) {
        if (!this.cameraOrientationIsTiedToDeviceOrientation()) {
            return OpenCvViewport.OptimizedRotation.NONE;
        }
        if (windowRotation == 0) {
            if (streamRotation == OpenCvCameraRotation.SIDEWAYS_LEFT) {
                return OpenCvViewport.OptimizedRotation.ROT_90_COUNTERCLOCWISE;
            }
            if (streamRotation == OpenCvCameraRotation.SIDEWAYS_RIGHT) {
                return OpenCvViewport.OptimizedRotation.ROT_90_CLOCKWISE;
            }
            if (streamRotation == OpenCvCameraRotation.UPSIDE_DOWN) {
                return OpenCvViewport.OptimizedRotation.ROT_180;
            }
            return OpenCvViewport.OptimizedRotation.NONE;
        }
        if (windowRotation == 1) {
            if (streamRotation == OpenCvCameraRotation.SIDEWAYS_RIGHT) {
                return OpenCvViewport.OptimizedRotation.ROT_180;
            }
            if (streamRotation == OpenCvCameraRotation.UPRIGHT) {
                return OpenCvViewport.OptimizedRotation.ROT_90_CLOCKWISE;
            }
            if (streamRotation == OpenCvCameraRotation.UPSIDE_DOWN) {
                return OpenCvViewport.OptimizedRotation.ROT_90_COUNTERCLOCWISE;
            }
            return OpenCvViewport.OptimizedRotation.NONE;
        }
        if (windowRotation == 3) {
            if (streamRotation == OpenCvCameraRotation.SIDEWAYS_LEFT) {
                return OpenCvViewport.OptimizedRotation.ROT_180;
            }
            if (streamRotation == OpenCvCameraRotation.UPRIGHT) {
                return OpenCvViewport.OptimizedRotation.ROT_90_COUNTERCLOCWISE;
            }
            if (streamRotation == OpenCvCameraRotation.UPSIDE_DOWN) {
                return OpenCvViewport.OptimizedRotation.ROT_90_CLOCKWISE;
            }
            return OpenCvViewport.OptimizedRotation.NONE;
        }
        return OpenCvViewport.OptimizedRotation.NONE;
    }

    protected abstract OpenCvCameraRotation getDefaultRotation();

    protected abstract int mapRotationEnumToOpenCvRotateCode(OpenCvCameraRotation var1);

    protected abstract boolean cameraOrientationIsTiedToDeviceOrientation();

    private class OpModeNotifications
    implements LIFO_OpModeCallbackDelegate.OnOpModeStoppedListener {
        private OpModeNotifications() {
        }

        @Override
        public void onOpModePostStop(OpMode opMode) {
            OpenCvCameraBase.this.hasBeenCleanedUp = true;
            RobotLog.unregisterGlobalWarningSource((GlobalWarningSource)OpenCvCameraBase.this);
            OpenCvCameraBase.this.closeCameraDevice();
        }
    }

    private class ComponentCallbacksForRotation
    implements ComponentCallbacks {
        private ComponentCallbacksForRotation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConfigurationChanged(Configuration newConfig) {
            int displayRot = AppUtil.getInstance().getActivity().getWindowManager().getDefaultDisplay().getRotation();
            OpenCvCameraBase openCvCameraBase = OpenCvCameraBase.this;
            synchronized (openCvCameraBase) {
                if (OpenCvCameraBase.this.viewport != null) {
                    OpenCvCameraBase.this.viewport.setOptimizedViewRotation(OpenCvCameraBase.this.getOptimizedViewportRotation(OpenCvCameraBase.this.rotation, displayRot));
                }
            }
        }

        public void onLowMemory() {
        }
    }

    private class OpModeNotificationsForOrientation
    implements OpModeManagerNotifier.Notifications {
        private OpModeNotificationsForOrientation() {
        }

        public void onOpModePreInit(OpMode opMode) {
        }

        public void onOpModePreStart(OpMode opMode) {
        }

        public void onOpModePostStop(OpMode opMode) {
            AppUtil.getInstance().getApplication().unregisterComponentCallbacks((ComponentCallbacks)OpenCvCameraBase.this.componentCallbacksForRotation);
            OpModeManagerImpl.getOpModeManagerOfActivity((Activity)AppUtil.getInstance().getActivity()).unregisterListener((OpModeManagerNotifier.Notifications)this);
        }
    }
}

