/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7.message;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.AbstractPrimitive;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.Escaping;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.util.DeepCopy;
import ca.uhn.hl7v2.util.ReflectionUtil;
import ca.uhn.hl7v2.util.Terser;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.openehealth.ipf.modules.hl7.HL7v2Exception;
import org.openehealth.ipf.modules.hl7.parser.DefaultEscaping;

public class MessageUtils
implements GroovyObject {
    private static final DateTimeFormatter FMT;
    private static final Escaping ESCAPE;
    private static final Parser PARSER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public MessageUtils() {
        MetaClass metaClass;
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        Object object = MessageUtils.$getCallSiteArray()[0].callGetProperty(DefaultEscaping.class);
        ESCAPE = (Escaping)ScriptBytecodeAdapter.castToType((Object)object, Escaping.class);
        Object object2 = MessageUtils.$getCallSiteArray()[1].call(DateTimeFormatter.class, (Object)"yyyyMMddHHmmss");
        FMT = (DateTimeFormatter)ScriptBytecodeAdapter.castToType((Object)object2, DateTimeFormatter.class);
        ParserConfiguration config = (ParserConfiguration)ScriptBytecodeAdapter.castToType((Object)MessageUtils.$getCallSiteArray()[2].callConstructor(ParserConfiguration.class), ParserConfiguration.class);
        Escaping escaping = ESCAPE;
        ScriptBytecodeAdapter.setProperty((Object)escaping, null, (Object)config, (String)"escaping");
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)MessageUtils.$getCallSiteArray()[3].callConstructor(DefaultHapiContext.class), HapiContext.class);
        ParserConfiguration parserConfiguration = config;
        ScriptBytecodeAdapter.setProperty((Object)parserConfiguration, null, (Object)context, (String)"parserConfiguration");
        Object object3 = MessageUtils.$getCallSiteArray()[4].call((Object)context);
        PARSER = (Parser)ScriptBytecodeAdapter.castToType((Object)object3, Parser.class);
    }

    public static boolean atLeastVersion(Message msg, String targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callStatic(MessageUtils.class, callSiteArray[6].callGetProperty((Object)msg), (Object)targetVersion));
    }

    public static boolean atLeastVersion(String actualVersion, String targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callStatic(MessageUtils.class, callSiteArray[8].call(Version.class, (Object)actualVersion), callSiteArray[9].call(Version.class, (Object)targetVersion)));
    }

    public static boolean atLeastVersion(Version actualVersion, Version targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)actualVersion, null) || ScriptBytecodeAdapter.compareEqual((Object)targetVersion, null)) {
                throw (Throwable)callSiteArray[10].callConstructor(IllegalArgumentException.class, (Object)"unknown HL7 version");
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)actualVersion, null) || ScriptBytecodeAdapter.compareEqual((Object)targetVersion, null)) {
            throw (Throwable)callSiteArray[11].callConstructor(IllegalArgumentException.class, (Object)"unknown HL7 version");
        }
        return !(ScriptBytecodeAdapter.compareEqual((Object)targetVersion, (Object)actualVersion) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call((Object)targetVersion, (Object)actualVersion)));
    }

    public static String hl7Now() {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[13].call(callSiteArray[14].call(ZonedDateTime.class), (Object)FMT));
    }

    public static String encodeHL7String(String s, Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        Object object = callSiteArray[15].callGetPropertySafe(callSiteArray[16].callGetPropertySafe(callSiteArray[17].callGetPropertySafe((Object)msg)));
        Escaping escaping = (Escaping)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ESCAPE), Escaping.class);
        return ShortTypeHandling.castToString((Object)callSiteArray[18].call((Object)escaping, (Object)s, callSiteArray[19].callStatic(MessageUtils.class, (Object)msg)));
    }

    public static String eventType(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[20].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[21].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)1, (Object)1)));
    }

    public static String triggerEvent(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[22].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[23].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)2, (Object)1)));
    }

    public static String messageStructure(String messageType, String triggerEvent, String version, ModelClassFactory factory) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        GStringImpl structName = new GStringImpl(new Object[]{messageType, triggerEvent}, new String[]{"", "_", ""});
        Object object = callSiteArray[24].call((Object)factory, (Object)structName, callSiteArray[25].call(Version.class, (Object)version));
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : structName));
    }

    public static String messageStructure(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[26].callStatic(MessageUtils.class, callSiteArray[27].callStatic(MessageUtils.class, (Object)msg), callSiteArray[28].callStatic(MessageUtils.class, (Object)msg), callSiteArray[29].callGetProperty((Object)msg), callSiteArray[30].callGetProperty(callSiteArray[31].callGetProperty(callSiteArray[32].callGetProperty((Object)msg)))));
    }

    public static Message defaultNak(HL7Exception e, AcknowledgmentCode ackCode, String version, String sendingApplication, String sendingFacility, String msh9) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        Object object = callSiteArray[34].callGetProperty((Object)e);
        Object cause = callSiteArray[33].callStatic(MessageUtils.class, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[35].callGetProperty(callSiteArray[36].callGetProperty((Object)e)), null);
        Object now = null;
        now = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? callSiteArray[37].callStatic(MessageUtils.class) : MessageUtils.hl7Now();
        Object cannedNak = callSiteArray[38].call(callSiteArray[39].call((Object)new GStringImpl(new Object[]{sendingApplication, sendingFacility, now, msh9, version}, new String[]{"MSH|^~\\&|", "|", "|unknown|unknown|", "||", "|unknown|T|", "|\r"}), (Object)new GStringImpl(new Object[]{cause}, new String[]{"MSA|AE|MsgIdUnknown|", "|\r"})), (Object)"ERR|\r");
        Object nak = callSiteArray[40].call((Object)PARSER, cannedNak);
        callSiteArray[41].call((Object)e, nak, (Object)ackCode, (Object)0);
        return (Message)ScriptBytecodeAdapter.castToType((Object)nak, Message.class);
    }

    public static Message defaultNak(HL7Exception e, AcknowledgmentCode ackCode, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callStatic(MessageUtils.class, ArrayUtil.createArray((Object)e, (Object)ackCode, (Object)version, (Object)"unknown", (Object)"unknown", (Object)"ACK")), Message.class);
    }

    public static Message newMessage(HapiContext context, String event, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)version)) {
            Object list = callSiteArray[43].call((Object)event, (Object)"_");
            Object eventType = callSiteArray[44].call(list, (Object)0);
            Object triggerEvent = callSiteArray[45].call(list, (Object)1);
            return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callStatic(MessageUtils.class, (Object)context, eventType, triggerEvent, (Object)version), Message.class);
        }
        throw (Throwable)callSiteArray[47].callConstructor(HL7Exception.class, (Object)"Must have valid version to create message");
    }

    public static Message response(Message msg, String eventType, String triggerEvent) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)triggerEvent)) {
            triggerEvent = ShortTypeHandling.castToString((Object)callSiteArray[48].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[49].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)2, (Object)1)));
        }
        String v = ShortTypeHandling.castToString((Object)callSiteArray[50].callGetProperty((Object)msg));
        Message out = (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callStatic(MessageUtils.class, callSiteArray[52].callGetProperty(callSiteArray[53].callGetProperty((Object)msg)), (Object)eventType, (Object)triggerEvent, (Object)v), Message.class);
        Segment mshIn = (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callGetProperty((Object)msg), Segment.class);
        Segment mshOut = (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].callGetProperty((Object)out), Segment.class);
        String fieldSep = ShortTypeHandling.castToString((Object)callSiteArray[56].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)1, (Object)0, (Object)1, (Object)1)));
        String encChars = ShortTypeHandling.castToString((Object)callSiteArray[57].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)2, (Object)0, (Object)1, (Object)1)));
        String procID = ShortTypeHandling.castToString((Object)callSiteArray[58].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)11, (Object)0, (Object)1, (Object)1)));
        callSiteArray[59].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)1, (Object)0, (Object)1, (Object)1, (Object)fieldSep));
        callSiteArray[60].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)2, (Object)0, (Object)1, (Object)1, (Object)encChars));
        callSiteArray[61].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)11, (Object)0, (Object)1, (Object)1, (Object)procID));
        callSiteArray[62].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)3, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[63].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)5, (Object)0, (Object)1, (Object)1))));
        callSiteArray[64].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)4, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[65].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)6, (Object)0, (Object)1, (Object)1))));
        callSiteArray[66].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)5, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[67].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)3, (Object)0, (Object)1, (Object)1))));
        callSiteArray[68].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)6, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[69].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)4, (Object)0, (Object)1, (Object)1))));
        if (ScriptBytecodeAdapter.isCase((Object)"MSA", (Object)callSiteArray[70].callGetProperty((Object)out))) {
            callSiteArray[71].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[72].callGetProperty((Object)out), (Object)2, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[73].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[74].callGetProperty((Object)msg), (Object)10, (Object)0, (Object)1, (Object)1))));
        }
        return out;
    }

    public static Message empty(Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[75].callStatic(MessageUtils.class, (Object)message, callSiteArray[76].callGetProperty(callSiteArray[77].callGetProperty(callSiteArray[78].callGetProperty((Object)message)))), Message.class);
    }

    public static Message copy(Message source) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].call(callSiteArray[80].callGetProperty((Object)source), callSiteArray[81].call((Object)source)), Message.class);
    }

    private static Group newInstance(Group group, ModelClassFactory factory) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        public final class _newInstance_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _newInstance_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callSafe(callSiteArray[1].callGetProperty(it)), (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(it), (Object)0), ModelClassFactory.class);
                }
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callSafe(callSiteArray[5].callGetProperty(it)), (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call(callSiteArray[7].callGetProperty(it), (Object)0), ModelClassFactory.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _newInstance_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "size";
                stringArray[1] = "parameterTypes";
                stringArray[2] = "getAt";
                stringArray[3] = "parameterTypes";
                stringArray[4] = "size";
                stringArray[5] = "parameterTypes";
                stringArray[6] = "getAt";
                stringArray[7] = "parameterTypes";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _newInstance_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_newInstance_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _newInstance_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Constructor constructor = (Constructor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].callSafe(callSiteArray[83].callGetPropertySafe(callSiteArray[84].callGetPropertySafe((Object)group)), (Object)new _newInstance_closure1(MessageUtils.class, MessageUtils.class)), Constructor.class);
        return (Group)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)constructor) && DefaultTypeTransformation.booleanUnbox((Object)factory) ? callSiteArray[85].call((Object)constructor, (Object)factory) : callSiteArray[86].callStatic(MessageUtils.class, (Object)group)), Group.class);
    }

    private static Group newInstance(Group group) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Group)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].call(callSiteArray[88].callGetProperty((Object)group)), Group.class);
    }

    public static Message makeMessage(HapiContext context, String eventType, String triggerEvent, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        ModelClassFactory factory = (ModelClassFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].callGetProperty((Object)context), ModelClassFactory.class);
        String structName = ScriptBytecodeAdapter.compareEqual((Object)eventType, (Object)"ACK") ? "ACK" : callSiteArray[90].callStatic(MessageUtils.class, (Object)eventType, (Object)triggerEvent, (Object)version, (Object)factory);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[91].call((Object)factory, (Object)structName, (Object)version, (Object)true));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            HL7Exception e = (HL7Exception)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{structName}, new String[]{"Can't instantiate message ", ""}), callSiteArray[93].callGetProperty(ErrorCode.class)), HL7Exception.class);
            throw (Throwable)callSiteArray[94].callConstructor(HL7v2Exception.class, (Object)e);
        }
        AbstractMessage msg = (AbstractMessage)ScriptBytecodeAdapter.castToType((Object)callSiteArray[95].call(ReflectionUtil.class, (Object)c, (Object)factory), AbstractMessage.class);
        callSiteArray[96].call((Object)msg, callSiteArray[97].call((Object)context));
        callSiteArray[98].call((Object)msg, (Object)eventType, (Object)triggerEvent, (Object)"P");
        callSiteArray[99].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[100].callGetProperty((Object)msg), (Object)11, (Object)0, (Object)2, (Object)1, (Object)"T"));
        return msg;
    }

    public static Segment newSegment(String name, Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].call(callSiteArray[102].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[103].call(callSiteArray[104].callGetProperty((Object)context), (Object)name, callSiteArray[105].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[106].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Segment ", ""}));
        }
        return (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].call(ReflectionUtil.class, (Object)c, (Object)message, callSiteArray[108].callGetProperty((Object)context)), Segment.class);
    }

    public static Group newGroup(String name, Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[109].call(callSiteArray[110].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[111].call(callSiteArray[112].callGetProperty((Object)context), (Object)name, callSiteArray[113].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[114].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Group ", ""}));
        }
        return (Group)ScriptBytecodeAdapter.castToType((Object)callSiteArray[115].call(ReflectionUtil.class, (Object)c, (Object)message, callSiteArray[116].callGetProperty((Object)context)), Group.class);
    }

    public static Primitive newPrimitive(String name, Message message, String value) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[117].call(callSiteArray[118].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[119].call(callSiteArray[120].callGetProperty((Object)context), (Object)name, callSiteArray[121].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[122].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Type ", ""}));
        }
        AbstractPrimitive primitive = (AbstractPrimitive)ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].call((Object)c, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Object[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{message}), Object[].class)), Object[].class)), AbstractPrimitive.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)value)) {
            callSiteArray[124].call((Object)primitive, (Object)value);
        }
        return primitive;
    }

    public static Composite newComposite(String name, Message message, Map map) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[125].call(callSiteArray[126].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[127].call(callSiteArray[128].callGetProperty((Object)context), (Object)name, callSiteArray[129].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[130].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Type ", ""}));
        }
        Reference composite = new Reference((Object)((Composite)ScriptBytecodeAdapter.castToType((Object)callSiteArray[131].call((Object)c, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Object[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{message}), Object[].class)), Object[].class)), Composite.class)));
        public final class _newComposite_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference composite;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _newComposite_closure2(Object _outerInstance, Object _thisObject, Reference composite) {
                Reference reference;
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.composite = reference = composite;
            }

            public Object doCall(Object k, Object v) {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                Type type = (Type)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getProperty(_newComposite_closure2.class, (Object)((Composite)ScriptBytecodeAdapter.castToType((Object)this.composite.get(), Composite.class)), (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{k}, new String[]{"", ""}))), Type.class);
                if (type instanceof Primitive && v instanceof String) {
                    return callSiteArray[0].call((Object)type, v);
                }
                return callSiteArray[1].call(DeepCopy.class, v, (Object)type);
            }

            @Generated
            public Object call(Object k, Object v) {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, k, v);
            }

            @Generated
            public Composite getComposite() {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                return (Composite)ScriptBytecodeAdapter.castToType((Object)this.composite.get(), Composite.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _newComposite_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "setValue";
                stringArray[1] = "copy";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _newComposite_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_newComposite_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _newComposite_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[132].callSafe((Object)map, (Object)new _newComposite_closure2(MessageUtils.class, MessageUtils.class, composite));
        return (Composite)composite.get();
    }

    public static Message load(HapiContext context, String resource) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].callStatic(MessageUtils.class, (Object)context, callSiteArray[134].callGetPropertySafe(callSiteArray[135].call(callSiteArray[136].callGetProperty(callSiteArray[137].callStatic(MessageUtils.class)), (Object)resource))), Message.class);
    }

    public static Message load(HapiContext context, String resource, String charset) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].callStatic(MessageUtils.class, (Object)context, callSiteArray[139].callSafe(callSiteArray[140].call(callSiteArray[141].callGetProperty(callSiteArray[142].callStatic(MessageUtils.class)), (Object)resource), (Object)charset)), Message.class);
    }

    public static Message make(HapiContext context, InputStream stream) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[143].callStatic(MessageUtils.class, (Object)context, callSiteArray[144].callGetPropertySafe((Object)stream)), Message.class);
    }

    public static Message make(HapiContext context, InputStream stream, String charset) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[145].callStatic(MessageUtils.class, (Object)context, callSiteArray[146].callSafe((Object)stream, (Object)charset)), Message.class);
    }

    public static Message make(HapiContext context, String message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)message)) {
            return (Message)ScriptBytecodeAdapter.castToType(null, Message.class);
        }
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[147].call(callSiteArray[148].callGetProperty((Object)context), (Object)message), Message.class);
    }

    private static EncodingCharacters encodingCharacters(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)msg, null)) {
            return (EncodingCharacters)ScriptBytecodeAdapter.castToType((Object)callSiteArray[149].call(EncodingCharacters.class, (Object)msg), EncodingCharacters.class);
        }
        return (EncodingCharacters)ScriptBytecodeAdapter.castToType((Object)callSiteArray[150].callConstructor(EncodingCharacters.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)Character.valueOf(DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)"|", Character.TYPE))), Character.TYPE), (Object)"^~\\&"), EncodingCharacters.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MessageUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "INSTANCE";
        stringArray[1] = "ofPattern";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "getGenericParser";
        stringArray[5] = "atLeastVersion";
        stringArray[6] = "version";
        stringArray[7] = "atLeastVersion";
        stringArray[8] = "versionOf";
        stringArray[9] = "versionOf";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "isGreaterThan";
        stringArray[13] = "format";
        stringArray[14] = "now";
        stringArray[15] = "escaping";
        stringArray[16] = "parserConfiguration";
        stringArray[17] = "parser";
        stringArray[18] = "escape";
        stringArray[19] = "encodingCharacters";
        stringArray[20] = "get";
        stringArray[21] = "MSH";
        stringArray[22] = "get";
        stringArray[23] = "MSH";
        stringArray[24] = "getMessageStructureForEvent";
        stringArray[25] = "versionOf";
        stringArray[26] = "messageStructure";
        stringArray[27] = "eventType";
        stringArray[28] = "triggerEvent";
        stringArray[29] = "version";
        stringArray[30] = "modelClassFactory";
        stringArray[31] = "hapiContext";
        stringArray[32] = "parser";
        stringArray[33] = "encodeHL7String";
        stringArray[34] = "message";
        stringArray[35] = "simpleName";
        stringArray[36] = "class";
        stringArray[37] = "hl7Now";
        stringArray[38] = "plus";
        stringArray[39] = "plus";
        stringArray[40] = "parse";
        stringArray[41] = "populateResponse";
        stringArray[42] = "defaultNak";
        stringArray[43] = "tokenize";
        stringArray[44] = "getAt";
        stringArray[45] = "getAt";
        stringArray[46] = "makeMessage";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "get";
        stringArray[49] = "MSH";
        stringArray[50] = "version";
        stringArray[51] = "makeMessage";
        stringArray[52] = "hapiContext";
        stringArray[53] = "parser";
        stringArray[54] = "MSH";
        stringArray[55] = "MSH";
        stringArray[56] = "get";
        stringArray[57] = "get";
        stringArray[58] = "get";
        stringArray[59] = "set";
        stringArray[60] = "set";
        stringArray[61] = "set";
        stringArray[62] = "set";
        stringArray[63] = "get";
        stringArray[64] = "set";
        stringArray[65] = "get";
        stringArray[66] = "set";
        stringArray[67] = "get";
        stringArray[68] = "set";
        stringArray[69] = "get";
        stringArray[70] = "names";
        stringArray[71] = "set";
        stringArray[72] = "MSA";
        stringArray[73] = "get";
        stringArray[74] = "MSH";
        stringArray[75] = "newInstance";
        stringArray[76] = "modelClassFactory";
        stringArray[77] = "hapiContext";
        stringArray[78] = "parser";
        stringArray[79] = "parse";
        stringArray[80] = "parser";
        stringArray[81] = "encode";
        stringArray[82] = "find";
        stringArray[83] = "constructors";
        stringArray[84] = "class";
        stringArray[85] = "newInstance";
        stringArray[86] = "newInstance";
        stringArray[87] = "newInstance";
        stringArray[88] = "class";
        stringArray[89] = "modelClassFactory";
        stringArray[90] = "messageStructure";
        stringArray[91] = "getMessageClass";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "UNSUPPORTED_MESSAGE_TYPE";
        stringArray[94] = "<$constructor$>";
        stringArray[95] = "instantiateMessage";
        stringArray[96] = "setParser";
        stringArray[97] = "getGenericParser";
        stringArray[98] = "initQuickstart";
        stringArray[99] = "set";
        stringArray[100] = "MSH";
        stringArray[101] = "getHapiContext";
        stringArray[102] = "getParser";
        stringArray[103] = "getSegmentClass";
        stringArray[104] = "modelClassFactory";
        stringArray[105] = "version";
        stringArray[106] = "<$constructor$>";
        stringArray[107] = "instantiateStructure";
        stringArray[108] = "modelClassFactory";
        stringArray[109] = "getHapiContext";
        stringArray[110] = "getParser";
        stringArray[111] = "getGroupClass";
        stringArray[112] = "modelClassFactory";
        stringArray[113] = "version";
        stringArray[114] = "<$constructor$>";
        stringArray[115] = "instantiateStructure";
        stringArray[116] = "modelClassFactory";
        stringArray[117] = "getHapiContext";
        stringArray[118] = "getParser";
        stringArray[119] = "getTypeClass";
        stringArray[120] = "modelClassFactory";
        stringArray[121] = "version";
        stringArray[122] = "<$constructor$>";
        stringArray[123] = "newInstance";
        stringArray[124] = "setValue";
        stringArray[125] = "getHapiContext";
        stringArray[126] = "getParser";
        stringArray[127] = "getTypeClass";
        stringArray[128] = "modelClassFactory";
        stringArray[129] = "version";
        stringArray[130] = "<$constructor$>";
        stringArray[131] = "newInstance";
        stringArray[132] = "each";
        stringArray[133] = "make";
        stringArray[134] = "text";
        stringArray[135] = "getResource";
        stringArray[136] = "classLoader";
        stringArray[137] = "getClass";
        stringArray[138] = "make";
        stringArray[139] = "getText";
        stringArray[140] = "getResource";
        stringArray[141] = "classLoader";
        stringArray[142] = "getClass";
        stringArray[143] = "make";
        stringArray[144] = "text";
        stringArray[145] = "make";
        stringArray[146] = "getText";
        stringArray[147] = "parse";
        stringArray[148] = "genericParser";
        stringArray[149] = "getInstance";
        stringArray[150] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[151];
        MessageUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MessageUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MessageUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

