/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.serviceutils.srm.shell;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.serviceutils.srm.shell.SrmCliUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.rpc.rev180626.OdlSrmRpcsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.rpc.rev180626.ReinstallInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.rpc.rev180626.ReinstallInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.rpc.rev180626.ReinstallOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityNameBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityTypeService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="srm", name="reinstall", description="Reinstall service or instance")
public class ReinstallCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ReinstallCommand.class);
    private final OdlSrmRpcsService srmRpcService;
    private final Class<? extends EntityTypeBase> entityType = EntityTypeService.class;
    @Argument(index=0, name="name", description="EntityName of type service, required", required=false, multiValued=false)
    String name;

    public ReinstallCommand(OdlSrmRpcsService srmRpcService) {
        this.srmRpcService = srmRpcService;
    }

    protected @Nullable Object doExecute() throws Exception {
        ReinstallInput input = this.getInput();
        if (input == null) {
            return null;
        }
        ListenableFuture result = this.srmRpcService.reinstall(input);
        RpcResult reinstallResult = (RpcResult)result.get();
        this.printResult((RpcResult<ReinstallOutput>)reinstallResult);
        return null;
    }

    private void printResult(RpcResult<ReinstallOutput> reinstallResult) {
        StringBuilder strResult = new StringBuilder("");
        if (reinstallResult.isSuccessful()) {
            strResult.append("RPC call to reinstall was successful");
            LOG.trace("RPC Result: {}", reinstallResult.getResult());
        } else {
            strResult.append("RPC Call to reinstall failed.\n").append("ErrorMsg: ").append(((ReinstallOutput)reinstallResult.getResult()).getMessage());
            LOG.trace("RPC Result: {}", reinstallResult.getResult());
        }
        this.session.getConsole().println(strResult.toString());
    }

    private @Nullable ReinstallInput getInput() {
        Class<? extends EntityNameBase> entityName = SrmCliUtils.getEntityName(this.entityType, this.name);
        if (entityName == null) {
            this.session.getConsole().println(SrmCliUtils.getNameHelp(this.entityType));
            return null;
        }
        ReinstallInputBuilder inputBuilder = new ReinstallInputBuilder();
        inputBuilder.setEntityType(this.entityType);
        inputBuilder.setEntityName(entityName);
        return inputBuilder.build();
    }
}

