/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sdninterfaceapp.impl.sdniwrapper;

import java.util.Timer;
import java.util.TimerTask;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.sdninterfaceapp.impl.sdniwrapper.SDNiClientCommunicator;
import org.opendaylight.sdninterfaceapp.impl.sdniwrapper.SDNiServerListener;
import org.opendaylight.sdninterfaceapp.impl.sdniwrapper.SdniMsgSynchronizer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.sdniwrapper.msg.rev170327.OpendaylightSdniWrapperService;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdniwrapperServiceProvider
implements BindingAwareProvider,
AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(SdniwrapperServiceProvider.class);
    private BindingAwareBroker.RpcRegistration<OpendaylightSdniWrapperService> wrapperService;
    private NotificationProviderService notificationProvider;

    public SdniwrapperServiceProvider(NotificationProviderService notificationProvider) {
        this.notificationProvider = notificationProvider;
    }

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        this.logger.info("Provider Session initialized");
        SdniMsgSynchronizer wrapperImpl = SdniMsgSynchronizer.getInstance();
        this.wrapperService = session.addRpcImplementation(OpendaylightSdniWrapperService.class, (RpcService)wrapperImpl);
        SdniMsgSynchronizer.getInstance().setNotificationService(this.notificationProvider);
        Timer serverTimer = new Timer();
        serverTimer.schedule((TimerTask)SDNiServerListener.getInstance(), 0L, 60000L);
        Timer clientTimer = new Timer();
        clientTimer.schedule((TimerTask)SDNiClientCommunicator.getInstance(), 20000L, 60000L);
    }

    @Override
    public void close() throws Exception {
        this.logger.info("QosDataService Closed");
        if (this.wrapperService != null) {
            this.wrapperService.close();
        }
    }
}

