/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.mark.grouping;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.mark.grouping.NxmNxCtMark;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmNxCtMarkBuilder
implements Builder<NxmNxCtMark> {
    private Long _ctMark;
    private Long _mask;
    Map<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>> augmentation = Collections.emptyMap();

    public NxmNxCtMarkBuilder() {
    }

    public NxmNxCtMarkBuilder(NxmNxCtMark base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>>(aug);
        }
        this._ctMark = base.getCtMark();
        this._mask = base.getMask();
    }

    public Long getCtMark() {
        return this._ctMark;
    }

    public Long getMask() {
        return this._mask;
    }

    public <E$$ extends Augmentation<NxmNxCtMark>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkCtMarkRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public NxmNxCtMarkBuilder setCtMark(Long value) {
        if (value != null) {
            NxmNxCtMarkBuilder.checkCtMarkRange(value);
        }
        this._ctMark = value;
        return this;
    }

    private static void checkMaskRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public NxmNxCtMarkBuilder setMask(Long value) {
        if (value != null) {
            NxmNxCtMarkBuilder.checkMaskRange(value);
        }
        this._mask = value;
        return this;
    }

    public NxmNxCtMarkBuilder addAugmentation(Class<? extends Augmentation<NxmNxCtMark>> augmentationType, Augmentation<NxmNxCtMark> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxmNxCtMarkBuilder removeAugmentation(Class<? extends Augmentation<NxmNxCtMark>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmNxCtMark build() {
        return new NxmNxCtMarkImpl(this);
    }

    private static final class NxmNxCtMarkImpl
    extends AbstractAugmentable<NxmNxCtMark>
    implements NxmNxCtMark {
        private final Long _ctMark;
        private final Long _mask;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxmNxCtMarkImpl(NxmNxCtMarkBuilder base) {
            super(base.augmentation);
            this._ctMark = base.getCtMark();
            this._mask = base.getMask();
        }

        @Override
        public Long getCtMark() {
            return this._ctMark;
        }

        @Override
        public Long getMask() {
            return this._mask;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ctMark);
            result = 31 * result + Objects.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxCtMark.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxmNxCtMark other = (NxmNxCtMark)obj;
            if (!Objects.equals(this._ctMark, other.getCtMark())) {
                return false;
            }
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmNxCtMarkImpl otherImpl = (NxmNxCtMarkImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxmNxCtMark");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ctMark", (Object)this._ctMark);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_mask", (Object)this._mask);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

