/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.output.to.port._case;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.output.to.port._case.FlowModOutputToPort;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowModOutputToPortBuilder
implements Builder<FlowModOutputToPort> {
    private Integer _flowModNumBits;
    private Long _srcField;
    private Integer _srcOfs;
    Map<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>> augmentation = Collections.emptyMap();

    public FlowModOutputToPortBuilder() {
    }

    public FlowModOutputToPortBuilder(FlowModOutputToPort base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>>(aug);
        }
        this._flowModNumBits = base.getFlowModNumBits();
        this._srcField = base.getSrcField();
        this._srcOfs = base.getSrcOfs();
    }

    public Integer getFlowModNumBits() {
        return this._flowModNumBits;
    }

    public Long getSrcField() {
        return this._srcField;
    }

    public Integer getSrcOfs() {
        return this._srcOfs;
    }

    public <E$$ extends Augmentation<FlowModOutputToPort>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkFlowModNumBitsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public FlowModOutputToPortBuilder setFlowModNumBits(Integer value) {
        if (value != null) {
            FlowModOutputToPortBuilder.checkFlowModNumBitsRange(value);
        }
        this._flowModNumBits = value;
        return this;
    }

    private static void checkSrcFieldRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public FlowModOutputToPortBuilder setSrcField(Long value) {
        if (value != null) {
            FlowModOutputToPortBuilder.checkSrcFieldRange(value);
        }
        this._srcField = value;
        return this;
    }

    private static void checkSrcOfsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public FlowModOutputToPortBuilder setSrcOfs(Integer value) {
        if (value != null) {
            FlowModOutputToPortBuilder.checkSrcOfsRange(value);
        }
        this._srcOfs = value;
        return this;
    }

    public FlowModOutputToPortBuilder addAugmentation(Class<? extends Augmentation<FlowModOutputToPort>> augmentationType, Augmentation<FlowModOutputToPort> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public FlowModOutputToPortBuilder removeAugmentation(Class<? extends Augmentation<FlowModOutputToPort>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlowModOutputToPort build() {
        return new FlowModOutputToPortImpl(this);
    }

    private static final class FlowModOutputToPortImpl
    extends AbstractAugmentable<FlowModOutputToPort>
    implements FlowModOutputToPort {
        private final Integer _flowModNumBits;
        private final Long _srcField;
        private final Integer _srcOfs;
        private int hash = 0;
        private volatile boolean hashValid = false;

        FlowModOutputToPortImpl(FlowModOutputToPortBuilder base) {
            super(base.augmentation);
            this._flowModNumBits = base.getFlowModNumBits();
            this._srcField = base.getSrcField();
            this._srcOfs = base.getSrcOfs();
        }

        @Override
        public Integer getFlowModNumBits() {
            return this._flowModNumBits;
        }

        @Override
        public Long getSrcField() {
            return this._srcField;
        }

        @Override
        public Integer getSrcOfs() {
            return this._srcOfs;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flowModNumBits);
            result = 31 * result + Objects.hashCode(this._srcField);
            result = 31 * result + Objects.hashCode(this._srcOfs);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModOutputToPort.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowModOutputToPort other = (FlowModOutputToPort)obj;
            if (!Objects.equals(this._flowModNumBits, other.getFlowModNumBits())) {
                return false;
            }
            if (!Objects.equals(this._srcField, other.getSrcField())) {
                return false;
            }
            if (!Objects.equals(this._srcOfs, other.getSrcOfs())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlowModOutputToPortImpl otherImpl = (FlowModOutputToPortImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"FlowModOutputToPort");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_flowModNumBits", (Object)this._flowModNumBits);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_srcField", (Object)this._srcField);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_srcOfs", (Object)this._srcOfs);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

