/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping.NxmNxReg;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmNxRegBuilder
implements Builder<NxmNxReg> {
    private Long _mask;
    private Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg> _reg;
    private Long _value;
    Map<Class<? extends Augmentation<NxmNxReg>>, Augmentation<NxmNxReg>> augmentation = Collections.emptyMap();

    public NxmNxRegBuilder() {
    }

    public NxmNxRegBuilder(NxmNxReg base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxReg>>, Augmentation<NxmNxReg>>(aug);
        }
        this._mask = base.getMask();
        this._reg = base.getReg();
        this._value = base.getValue();
    }

    public Long getMask() {
        return this._mask;
    }

    public Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg> getReg() {
        return this._reg;
    }

    public Long getValue() {
        return this._value;
    }

    public <E$$ extends Augmentation<NxmNxReg>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkMaskRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public NxmNxRegBuilder setMask(Long value) {
        if (value != null) {
            NxmNxRegBuilder.checkMaskRange(value);
        }
        this._mask = value;
        return this;
    }

    public NxmNxRegBuilder setReg(Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg> value) {
        this._reg = value;
        return this;
    }

    private static void checkValueRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public NxmNxRegBuilder setValue(Long value) {
        if (value != null) {
            NxmNxRegBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public NxmNxRegBuilder addAugmentation(Class<? extends Augmentation<NxmNxReg>> augmentationType, Augmentation<NxmNxReg> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxReg>>, Augmentation<NxmNxReg>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxmNxRegBuilder removeAugmentation(Class<? extends Augmentation<NxmNxReg>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmNxReg build() {
        return new NxmNxRegImpl(this);
    }

    private static final class NxmNxRegImpl
    extends AbstractAugmentable<NxmNxReg>
    implements NxmNxReg {
        private final Long _mask;
        private final Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg> _reg;
        private final Long _value;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxmNxRegImpl(NxmNxRegBuilder base) {
            super(base.augmentation);
            this._mask = base.getMask();
            this._reg = base.getReg();
            this._value = base.getValue();
        }

        @Override
        public Long getMask() {
            return this._mask;
        }

        @Override
        public Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg> getReg() {
            return this._reg;
        }

        @Override
        public Long getValue() {
            return this._value;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mask);
            result = 31 * result + Objects.hashCode(this._reg);
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxReg.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxmNxReg other = (NxmNxReg)obj;
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(this._reg, other.getReg())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmNxRegImpl otherImpl = (NxmNxRegImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxmNxReg");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_mask", (Object)this._mask);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_reg", this._reg);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

