package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.flags.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxNshFlagsBuilder} instances.
 *
 * @see NxmNxNshFlagsBuilder
 *
 */
public class NxmNxNshFlagsBuilder implements Builder<NxmNxNshFlags> {

    private Short _mask;
    private Short _nshFlags;


    Map<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>> augmentation = Collections.emptyMap();

    public NxmNxNshFlagsBuilder() {
    }

    public NxmNxNshFlagsBuilder(NxmNxNshFlags base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>> aug =((AugmentationHolder<NxmNxNshFlags>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._mask = base.getMask();
        this._nshFlags = base.getNshFlags();
    }


    public Short getMask() {
        return _mask;
    }
    
    public Short getNshFlags() {
        return _nshFlags;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxNshFlags>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkMaskRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }
    
    public NxmNxNshFlagsBuilder setMask(final Short value) {
    if (value != null) {
        checkMaskRange(value);
        
    }
        this._mask = value;
        return this;
    }
    private static void checkNshFlagsRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }
    
    public NxmNxNshFlagsBuilder setNshFlags(final Short value) {
    if (value != null) {
        checkNshFlagsRange(value);
        
    }
        this._nshFlags = value;
        return this;
    }
    
    public NxmNxNshFlagsBuilder addAugmentation(Class<? extends Augmentation<NxmNxNshFlags>> augmentationType, Augmentation<NxmNxNshFlags> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxNshFlagsBuilder removeAugmentation(Class<? extends Augmentation<NxmNxNshFlags>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxNshFlags build() {
        return new NxmNxNshFlagsImpl(this);
    }

    private static final class NxmNxNshFlagsImpl
        extends AbstractAugmentable<NxmNxNshFlags>
        implements NxmNxNshFlags {
    
        private final Short _mask;
        private final Short _nshFlags;
    
        NxmNxNshFlagsImpl(NxmNxNshFlagsBuilder base) {
            super(base.augmentation);
            this._mask = base.getMask();
            this._nshFlags = base.getNshFlags();
        }
    
        @Override
        public Short getMask() {
            return _mask;
        }
        
        @Override
        public Short getNshFlags() {
            return _nshFlags;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mask);
            result = prime * result + Objects.hashCode(_nshFlags);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxNshFlags.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxmNxNshFlags other = (NxmNxNshFlags)obj;
            if (!Objects.equals(_mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(_nshFlags, other.getNshFlags())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxNshFlagsImpl otherImpl = (NxmNxNshFlagsImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxNshFlags");
            CodeHelpers.appendValue(helper, "_mask", _mask);
            CodeHelpers.appendValue(helper, "_nshFlags", _nshFlags);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
