package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.group.input.updated.group.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.dec.nsh.ttl.grouping.NxDecNshTtl;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionDecNshTtlRpcUpdateGroupUpdatedCaseBuilder} instances.
 *
 * @see NxActionDecNshTtlRpcUpdateGroupUpdatedCaseBuilder
 *
 */
public class NxActionDecNshTtlRpcUpdateGroupUpdatedCaseBuilder implements Builder<NxActionDecNshTtlRpcUpdateGroupUpdatedCase> {

    private NxDecNshTtl _nxDecNshTtl;


    Map<Class<? extends Augmentation<NxActionDecNshTtlRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionDecNshTtlRpcUpdateGroupUpdatedCase>> augmentation = Collections.emptyMap();

    public NxActionDecNshTtlRpcUpdateGroupUpdatedCaseBuilder() {
    }
    public NxActionDecNshTtlRpcUpdateGroupUpdatedCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping arg) {
        this._nxDecNshTtl = arg.getNxDecNshTtl();
    }

    public NxActionDecNshTtlRpcUpdateGroupUpdatedCaseBuilder(NxActionDecNshTtlRpcUpdateGroupUpdatedCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionDecNshTtlRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionDecNshTtlRpcUpdateGroupUpdatedCase>> aug =((AugmentationHolder<NxActionDecNshTtlRpcUpdateGroupUpdatedCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxDecNshTtl = base.getNxDecNshTtl();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping) {
            this._nxDecNshTtl = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping)arg).getNxDecNshTtl();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping]");
    }

    public NxDecNshTtl getNxDecNshTtl() {
        return _nxDecNshTtl;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionDecNshTtlRpcUpdateGroupUpdatedCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionDecNshTtlRpcUpdateGroupUpdatedCaseBuilder setNxDecNshTtl(final NxDecNshTtl value) {
        this._nxDecNshTtl = value;
        return this;
    }
    
    public NxActionDecNshTtlRpcUpdateGroupUpdatedCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionDecNshTtlRpcUpdateGroupUpdatedCase>> augmentationType, Augmentation<NxActionDecNshTtlRpcUpdateGroupUpdatedCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionDecNshTtlRpcUpdateGroupUpdatedCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionDecNshTtlRpcUpdateGroupUpdatedCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionDecNshTtlRpcUpdateGroupUpdatedCase build() {
        return new NxActionDecNshTtlRpcUpdateGroupUpdatedCaseImpl(this);
    }

    private static final class NxActionDecNshTtlRpcUpdateGroupUpdatedCaseImpl
        extends AbstractAugmentable<NxActionDecNshTtlRpcUpdateGroupUpdatedCase>
        implements NxActionDecNshTtlRpcUpdateGroupUpdatedCase {
    
        private final NxDecNshTtl _nxDecNshTtl;
    
        NxActionDecNshTtlRpcUpdateGroupUpdatedCaseImpl(NxActionDecNshTtlRpcUpdateGroupUpdatedCaseBuilder base) {
            super(base.augmentation);
            this._nxDecNshTtl = base.getNxDecNshTtl();
        }
    
        @Override
        public NxDecNshTtl getNxDecNshTtl() {
            return _nxDecNshTtl;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxDecNshTtl);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionDecNshTtlRpcUpdateGroupUpdatedCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxActionDecNshTtlRpcUpdateGroupUpdatedCase other = (NxActionDecNshTtlRpcUpdateGroupUpdatedCase)obj;
            if (!Objects.equals(_nxDecNshTtl, other.getNxDecNshTtl())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionDecNshTtlRpcUpdateGroupUpdatedCaseImpl otherImpl = (NxActionDecNshTtlRpcUpdateGroupUpdatedCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionDecNshTtlRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionDecNshTtlRpcUpdateGroupUpdatedCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionDecNshTtlRpcUpdateGroupUpdatedCase");
            CodeHelpers.appendValue(helper, "_nxDecNshTtl", _nxDecNshTtl);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
