package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link SrcOfEthSrcCaseBuilder} instances.
 *
 * @see SrcOfEthSrcCaseBuilder
 *
 */
public class SrcOfEthSrcCaseBuilder implements Builder<SrcOfEthSrcCase> {

    private Empty _ofEthSrc;


    Map<Class<? extends Augmentation<SrcOfEthSrcCase>>, Augmentation<SrcOfEthSrcCase>> augmentation = Collections.emptyMap();

    public SrcOfEthSrcCaseBuilder() {
    }
    public SrcOfEthSrcCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping arg) {
        this._ofEthSrc = arg.getOfEthSrc();
    }

    public SrcOfEthSrcCaseBuilder(SrcOfEthSrcCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcOfEthSrcCase>>, Augmentation<SrcOfEthSrcCase>> aug =((AugmentationHolder<SrcOfEthSrcCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ofEthSrc = base.getOfEthSrc();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping) {
            this._ofEthSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping)arg).getOfEthSrc();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthSrcGrouping]");
    }

    public Empty getOfEthSrc() {
        return _ofEthSrc;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcOfEthSrcCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcOfEthSrcCaseBuilder setOfEthSrc(final Empty value) {
        this._ofEthSrc = value;
        return this;
    }
    
    public SrcOfEthSrcCaseBuilder addAugmentation(Class<? extends Augmentation<SrcOfEthSrcCase>> augmentationType, Augmentation<SrcOfEthSrcCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcOfEthSrcCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcOfEthSrcCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcOfEthSrcCase build() {
        return new SrcOfEthSrcCaseImpl(this);
    }

    private static final class SrcOfEthSrcCaseImpl
        extends AbstractAugmentable<SrcOfEthSrcCase>
        implements SrcOfEthSrcCase {
    
        private final Empty _ofEthSrc;
    
        SrcOfEthSrcCaseImpl(SrcOfEthSrcCaseBuilder base) {
            super(base.augmentation);
            this._ofEthSrc = base.getOfEthSrc();
        }
    
        @Override
        public Empty getOfEthSrc() {
            return _ofEthSrc;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofEthSrc);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcOfEthSrcCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SrcOfEthSrcCase other = (SrcOfEthSrcCase)obj;
            if (!Objects.equals(_ofEthSrc, other.getOfEthSrc())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcOfEthSrcCaseImpl otherImpl = (SrcOfEthSrcCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcOfEthSrcCase>>, Augmentation<SrcOfEthSrcCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcOfEthSrcCase");
            CodeHelpers.appendValue(helper, "_ofEthSrc", _ofEthSrc);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
