package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link SrcNxNshc2CaseBuilder} instances.
 *
 * @see SrcNxNshc2CaseBuilder
 *
 */
public class SrcNxNshc2CaseBuilder implements Builder<SrcNxNshc2Case> {

    private Empty _nxNshc2Dst;


    Map<Class<? extends Augmentation<SrcNxNshc2Case>>, Augmentation<SrcNxNshc2Case>> augmentation = Collections.emptyMap();

    public SrcNxNshc2CaseBuilder() {
    }
    public SrcNxNshc2CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping arg) {
        this._nxNshc2Dst = arg.getNxNshc2Dst();
    }

    public SrcNxNshc2CaseBuilder(SrcNxNshc2Case base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxNshc2Case>>, Augmentation<SrcNxNshc2Case>> aug =((AugmentationHolder<SrcNxNshc2Case>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxNshc2Dst = base.getNxNshc2Dst();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping) {
            this._nxNshc2Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping)arg).getNxNshc2Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping]");
    }

    public Empty getNxNshc2Dst() {
        return _nxNshc2Dst;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxNshc2Case>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxNshc2CaseBuilder setNxNshc2Dst(final Empty value) {
        this._nxNshc2Dst = value;
        return this;
    }
    
    public SrcNxNshc2CaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxNshc2Case>> augmentationType, Augmentation<SrcNxNshc2Case> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxNshc2CaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxNshc2Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxNshc2Case build() {
        return new SrcNxNshc2CaseImpl(this);
    }

    private static final class SrcNxNshc2CaseImpl
        extends AbstractAugmentable<SrcNxNshc2Case>
        implements SrcNxNshc2Case {
    
        private final Empty _nxNshc2Dst;
    
        SrcNxNshc2CaseImpl(SrcNxNshc2CaseBuilder base) {
            super(base.augmentation);
            this._nxNshc2Dst = base.getNxNshc2Dst();
        }
    
        @Override
        public Empty getNxNshc2Dst() {
            return _nxNshc2Dst;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshc2Dst);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxNshc2Case.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SrcNxNshc2Case other = (SrcNxNshc2Case)obj;
            if (!Objects.equals(_nxNshc2Dst, other.getNxNshc2Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxNshc2CaseImpl otherImpl = (SrcNxNshc2CaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxNshc2Case>>, Augmentation<SrcNxNshc2Case>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxNshc2Case");
            CodeHelpers.appendValue(helper, "_nxNshc2Dst", _nxNshc2Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
