package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link SrcNxNshMdtypeCaseBuilder} instances.
 *
 * @see SrcNxNshMdtypeCaseBuilder
 *
 */
public class SrcNxNshMdtypeCaseBuilder implements Builder<SrcNxNshMdtypeCase> {

    private Empty _nxNshMdtype;


    Map<Class<? extends Augmentation<SrcNxNshMdtypeCase>>, Augmentation<SrcNxNshMdtypeCase>> augmentation = Collections.emptyMap();

    public SrcNxNshMdtypeCaseBuilder() {
    }
    public SrcNxNshMdtypeCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshMdtypeGrouping arg) {
        this._nxNshMdtype = arg.getNxNshMdtype();
    }

    public SrcNxNshMdtypeCaseBuilder(SrcNxNshMdtypeCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxNshMdtypeCase>>, Augmentation<SrcNxNshMdtypeCase>> aug =((AugmentationHolder<SrcNxNshMdtypeCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxNshMdtype = base.getNxNshMdtype();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshMdtypeGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshMdtypeGrouping) {
            this._nxNshMdtype = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshMdtypeGrouping)arg).getNxNshMdtype();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshMdtypeGrouping]");
    }

    public Empty getNxNshMdtype() {
        return _nxNshMdtype;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxNshMdtypeCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxNshMdtypeCaseBuilder setNxNshMdtype(final Empty value) {
        this._nxNshMdtype = value;
        return this;
    }
    
    public SrcNxNshMdtypeCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxNshMdtypeCase>> augmentationType, Augmentation<SrcNxNshMdtypeCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxNshMdtypeCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxNshMdtypeCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxNshMdtypeCase build() {
        return new SrcNxNshMdtypeCaseImpl(this);
    }

    private static final class SrcNxNshMdtypeCaseImpl
        extends AbstractAugmentable<SrcNxNshMdtypeCase>
        implements SrcNxNshMdtypeCase {
    
        private final Empty _nxNshMdtype;
    
        SrcNxNshMdtypeCaseImpl(SrcNxNshMdtypeCaseBuilder base) {
            super(base.augmentation);
            this._nxNshMdtype = base.getNxNshMdtype();
        }
    
        @Override
        public Empty getNxNshMdtype() {
            return _nxNshMdtype;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshMdtype);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxNshMdtypeCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SrcNxNshMdtypeCase other = (SrcNxNshMdtypeCase)obj;
            if (!Objects.equals(_nxNshMdtype, other.getNxNshMdtype())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxNshMdtypeCaseImpl otherImpl = (SrcNxNshMdtypeCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxNshMdtypeCase>>, Augmentation<SrcNxNshMdtypeCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxNshMdtypeCase");
            CodeHelpers.appendValue(helper, "_nxNshMdtype", _nxNshMdtype);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
