package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.remove.group.input.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.NxRegMove;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionRegMoveRpcRemoveGroupCaseBuilder} instances.
 *
 * @see NxActionRegMoveRpcRemoveGroupCaseBuilder
 *
 */
public class NxActionRegMoveRpcRemoveGroupCaseBuilder implements Builder<NxActionRegMoveRpcRemoveGroupCase> {

    private NxRegMove _nxRegMove;


    Map<Class<? extends Augmentation<NxActionRegMoveRpcRemoveGroupCase>>, Augmentation<NxActionRegMoveRpcRemoveGroupCase>> augmentation = Collections.emptyMap();

    public NxActionRegMoveRpcRemoveGroupCaseBuilder() {
    }
    public NxActionRegMoveRpcRemoveGroupCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping arg) {
        this._nxRegMove = arg.getNxRegMove();
    }

    public NxActionRegMoveRpcRemoveGroupCaseBuilder(NxActionRegMoveRpcRemoveGroupCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionRegMoveRpcRemoveGroupCase>>, Augmentation<NxActionRegMoveRpcRemoveGroupCase>> aug =((AugmentationHolder<NxActionRegMoveRpcRemoveGroupCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxRegMove = base.getNxRegMove();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping) {
            this._nxRegMove = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping)arg).getNxRegMove();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping]");
    }

    public NxRegMove getNxRegMove() {
        return _nxRegMove;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionRegMoveRpcRemoveGroupCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionRegMoveRpcRemoveGroupCaseBuilder setNxRegMove(final NxRegMove value) {
        this._nxRegMove = value;
        return this;
    }
    
    public NxActionRegMoveRpcRemoveGroupCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionRegMoveRpcRemoveGroupCase>> augmentationType, Augmentation<NxActionRegMoveRpcRemoveGroupCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionRegMoveRpcRemoveGroupCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionRegMoveRpcRemoveGroupCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionRegMoveRpcRemoveGroupCase build() {
        return new NxActionRegMoveRpcRemoveGroupCaseImpl(this);
    }

    private static final class NxActionRegMoveRpcRemoveGroupCaseImpl
        extends AbstractAugmentable<NxActionRegMoveRpcRemoveGroupCase>
        implements NxActionRegMoveRpcRemoveGroupCase {
    
        private final NxRegMove _nxRegMove;
    
        NxActionRegMoveRpcRemoveGroupCaseImpl(NxActionRegMoveRpcRemoveGroupCaseBuilder base) {
            super(base.augmentation);
            this._nxRegMove = base.getNxRegMove();
        }
    
        @Override
        public NxRegMove getNxRegMove() {
            return _nxRegMove;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxRegMove);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionRegMoveRpcRemoveGroupCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxActionRegMoveRpcRemoveGroupCase other = (NxActionRegMoveRpcRemoveGroupCase)obj;
            if (!Objects.equals(_nxRegMove, other.getNxRegMove())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionRegMoveRpcRemoveGroupCaseImpl otherImpl = (NxActionRegMoveRpcRemoveGroupCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionRegMoveRpcRemoveGroupCase>>, Augmentation<NxActionRegMoveRpcRemoveGroupCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionRegMoveRpcRemoveGroupCase");
            CodeHelpers.appendValue(helper, "_nxRegMove", _nxRegMove);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
