package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxResubmitBuilder} instances.
 *
 * @see NxResubmitBuilder
 *
 */
public class NxResubmitBuilder implements Builder<NxResubmit> {

    private Integer _inPort;
    private Short _table;


    Map<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> augmentation = Collections.emptyMap();

    public NxResubmitBuilder() {
    }

    public NxResubmitBuilder(NxResubmit base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> aug =((AugmentationHolder<NxResubmit>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._inPort = base.getInPort();
        this._table = base.getTable();
    }


    public Integer getInPort() {
        return _inPort;
    }
    
    public Short getTable() {
        return _table;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxResubmit>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkInPortRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public NxResubmitBuilder setInPort(final Integer value) {
    if (value != null) {
        checkInPortRange(value);
        
    }
        this._inPort = value;
        return this;
    }
    private static void checkTableRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }
    
    public NxResubmitBuilder setTable(final Short value) {
    if (value != null) {
        checkTableRange(value);
        
    }
        this._table = value;
        return this;
    }
    
    public NxResubmitBuilder addAugmentation(Class<? extends Augmentation<NxResubmit>> augmentationType, Augmentation<NxResubmit> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxResubmitBuilder removeAugmentation(Class<? extends Augmentation<NxResubmit>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxResubmit build() {
        return new NxResubmitImpl(this);
    }

    private static final class NxResubmitImpl
        extends AbstractAugmentable<NxResubmit>
        implements NxResubmit {
    
        private final Integer _inPort;
        private final Short _table;
    
        NxResubmitImpl(NxResubmitBuilder base) {
            super(base.augmentation);
            this._inPort = base.getInPort();
            this._table = base.getTable();
        }
    
        @Override
        public Integer getInPort() {
            return _inPort;
        }
        
        @Override
        public Short getTable() {
            return _table;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_inPort);
            result = prime * result + Objects.hashCode(_table);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxResubmit.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxResubmit other = (NxResubmit)obj;
            if (!Objects.equals(_inPort, other.getInPort())) {
                return false;
            }
            if (!Objects.equals(_table, other.getTable())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxResubmitImpl otherImpl = (NxResubmitImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxResubmit");
            CodeHelpers.appendValue(helper, "_inPort", _inPort);
            CodeHelpers.appendValue(helper, "_table", _table);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
