package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.load.grouping.nx.reg.load;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.DstChoice;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstBuilder} instances.
 *
 * @see DstBuilder
 *
 */
public class DstBuilder implements Builder<Dst> {

    private DstChoice _dstChoice;
    private Integer _end;
    private Integer _start;


    Map<Class<? extends Augmentation<Dst>>, Augmentation<Dst>> augmentation = Collections.emptyMap();

    public DstBuilder() {
    }
    public DstBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.DstChoiceGrouping arg) {
        this._dstChoice = arg.getDstChoice();
    }
    public DstBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping arg) {
        this._start = arg.getStart();
        this._end = arg.getEnd();
    }

    public DstBuilder(Dst base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Dst>>, Augmentation<Dst>> aug =((AugmentationHolder<Dst>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._dstChoice = base.getDstChoice();
        this._end = base.getEnd();
        this._start = base.getStart();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.DstChoiceGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping) {
            this._start = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping)arg).getStart();
            this._end = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping)arg).getEnd();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.DstChoiceGrouping) {
            this._dstChoice = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.DstChoiceGrouping)arg).getDstChoice();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.DstChoiceGrouping]");
    }

    public DstChoice getDstChoice() {
        return _dstChoice;
    }
    
    public Integer getEnd() {
        return _end;
    }
    
    public Integer getStart() {
        return _start;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Dst>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstBuilder setDstChoice(final DstChoice value) {
        this._dstChoice = value;
        return this;
    }
    private static void checkEndRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public DstBuilder setEnd(final Integer value) {
    if (value != null) {
        checkEndRange(value);
        
    }
        this._end = value;
        return this;
    }
    private static void checkStartRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public DstBuilder setStart(final Integer value) {
    if (value != null) {
        checkStartRange(value);
        
    }
        this._start = value;
        return this;
    }
    
    public DstBuilder addAugmentation(Class<? extends Augmentation<Dst>> augmentationType, Augmentation<Dst> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstBuilder removeAugmentation(Class<? extends Augmentation<Dst>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Dst build() {
        return new DstImpl(this);
    }

    private static final class DstImpl
        extends AbstractAugmentable<Dst>
        implements Dst {
    
        private final DstChoice _dstChoice;
        private final Integer _end;
        private final Integer _start;
    
        DstImpl(DstBuilder base) {
            super(base.augmentation);
            this._dstChoice = base.getDstChoice();
            this._end = base.getEnd();
            this._start = base.getStart();
        }
    
        @Override
        public DstChoice getDstChoice() {
            return _dstChoice;
        }
        
        @Override
        public Integer getEnd() {
            return _end;
        }
        
        @Override
        public Integer getStart() {
            return _start;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dstChoice);
            result = prime * result + Objects.hashCode(_end);
            result = prime * result + Objects.hashCode(_start);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Dst.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Dst other = (Dst)obj;
            if (!Objects.equals(_dstChoice, other.getDstChoice())) {
                return false;
            }
            if (!Objects.equals(_end, other.getEnd())) {
                return false;
            }
            if (!Objects.equals(_start, other.getStart())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstImpl otherImpl = (DstImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Dst>>, Augmentation<Dst>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Dst");
            CodeHelpers.appendValue(helper, "_dstChoice", _dstChoice);
            CodeHelpers.appendValue(helper, "_end", _end);
            CodeHelpers.appendValue(helper, "_start", _start);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
