package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.encap.grouping.NxEncap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder} instances.
 *
 * @see NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder
 *
 */
public class NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder implements Builder<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase> {

    private NxEncap _nxEncap;


    Map<Class<? extends Augmentation<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder() {
    }
    public NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping arg) {
        this._nxEncap = arg.getNxEncap();
    }

    public NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder(NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase>> aug =((AugmentationHolder<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxEncap = base.getNxEncap();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping) {
            this._nxEncap = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping)arg).getNxEncap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping]");
    }

    public NxEncap getNxEncap() {
        return _nxEncap;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder setNxEncap(final NxEncap value) {
        this._nxEncap = value;
        return this;
    }
    
    public NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase>> augmentationType, Augmentation<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase build() {
        return new NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseImpl(this);
    }

    private static final class NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseImpl
        extends AbstractAugmentable<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase>
        implements NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase {
    
        private final NxEncap _nxEncap;
    
        NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseImpl(NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxEncap = base.getNxEncap();
        }
    
        @Override
        public NxEncap getNxEncap() {
            return _nxEncap;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxEncap);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase other = (NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase)obj;
            if (!Objects.equals(_nxEncap, other.getNxEncap())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseImpl otherImpl = (NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionEncapNotifDirectStatisticsUpdateApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxEncap", _nxEncap);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
