package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.output.to.port._case;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModOutputToPortBuilder} instances.
 *
 * @see FlowModOutputToPortBuilder
 *
 */
public class FlowModOutputToPortBuilder implements Builder<FlowModOutputToPort> {

    private Integer _flowModNumBits;
    private Long _srcField;
    private Integer _srcOfs;


    Map<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>> augmentation = Collections.emptyMap();

    public FlowModOutputToPortBuilder() {
    }

    public FlowModOutputToPortBuilder(FlowModOutputToPort base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>> aug =((AugmentationHolder<FlowModOutputToPort>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowModNumBits = base.getFlowModNumBits();
        this._srcField = base.getSrcField();
        this._srcOfs = base.getSrcOfs();
    }


    public Integer getFlowModNumBits() {
        return _flowModNumBits;
    }
    
    public Long getSrcField() {
        return _srcField;
    }
    
    public Integer getSrcOfs() {
        return _srcOfs;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModOutputToPort>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkFlowModNumBitsRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModOutputToPortBuilder setFlowModNumBits(final Integer value) {
    if (value != null) {
        checkFlowModNumBitsRange(value);
        
    }
        this._flowModNumBits = value;
        return this;
    }
    private static void checkSrcFieldRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public FlowModOutputToPortBuilder setSrcField(final Long value) {
    if (value != null) {
        checkSrcFieldRange(value);
        
    }
        this._srcField = value;
        return this;
    }
    private static void checkSrcOfsRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModOutputToPortBuilder setSrcOfs(final Integer value) {
    if (value != null) {
        checkSrcOfsRange(value);
        
    }
        this._srcOfs = value;
        return this;
    }
    
    public FlowModOutputToPortBuilder addAugmentation(Class<? extends Augmentation<FlowModOutputToPort>> augmentationType, Augmentation<FlowModOutputToPort> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModOutputToPortBuilder removeAugmentation(Class<? extends Augmentation<FlowModOutputToPort>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModOutputToPort build() {
        return new FlowModOutputToPortImpl(this);
    }

    private static final class FlowModOutputToPortImpl
        extends AbstractAugmentable<FlowModOutputToPort>
        implements FlowModOutputToPort {
    
        private final Integer _flowModNumBits;
        private final Long _srcField;
        private final Integer _srcOfs;
    
        FlowModOutputToPortImpl(FlowModOutputToPortBuilder base) {
            super(base.augmentation);
            this._flowModNumBits = base.getFlowModNumBits();
            this._srcField = base.getSrcField();
            this._srcOfs = base.getSrcOfs();
        }
    
        @Override
        public Integer getFlowModNumBits() {
            return _flowModNumBits;
        }
        
        @Override
        public Long getSrcField() {
            return _srcField;
        }
        
        @Override
        public Integer getSrcOfs() {
            return _srcOfs;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModNumBits);
            result = prime * result + Objects.hashCode(_srcField);
            result = prime * result + Objects.hashCode(_srcOfs);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModOutputToPort.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowModOutputToPort other = (FlowModOutputToPort)obj;
            if (!Objects.equals(_flowModNumBits, other.getFlowModNumBits())) {
                return false;
            }
            if (!Objects.equals(_srcField, other.getSrcField())) {
                return false;
            }
            if (!Objects.equals(_srcOfs, other.getSrcOfs())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModOutputToPortImpl otherImpl = (FlowModOutputToPortImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModOutputToPort");
            CodeHelpers.appendValue(helper, "_flowModNumBits", _flowModNumBits);
            CodeHelpers.appendValue(helper, "_srcField", _srcField);
            CodeHelpers.appendValue(helper, "_srcOfs", _srcOfs);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
