package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link DstNxArpThaCaseBuilder} instances.
 *
 * @see DstNxArpThaCaseBuilder
 *
 */
public class DstNxArpThaCaseBuilder implements Builder<DstNxArpThaCase> {

    private Empty _nxArpTha;


    Map<Class<? extends Augmentation<DstNxArpThaCase>>, Augmentation<DstNxArpThaCase>> augmentation = Collections.emptyMap();

    public DstNxArpThaCaseBuilder() {
    }
    public DstNxArpThaCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping arg) {
        this._nxArpTha = arg.getNxArpTha();
    }

    public DstNxArpThaCaseBuilder(DstNxArpThaCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxArpThaCase>>, Augmentation<DstNxArpThaCase>> aug =((AugmentationHolder<DstNxArpThaCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxArpTha = base.getNxArpTha();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping) {
            this._nxArpTha = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping)arg).getNxArpTha();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping]");
    }

    public Empty getNxArpTha() {
        return _nxArpTha;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxArpThaCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxArpThaCaseBuilder setNxArpTha(final Empty value) {
        this._nxArpTha = value;
        return this;
    }
    
    public DstNxArpThaCaseBuilder addAugmentation(Class<? extends Augmentation<DstNxArpThaCase>> augmentationType, Augmentation<DstNxArpThaCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxArpThaCaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxArpThaCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxArpThaCase build() {
        return new DstNxArpThaCaseImpl(this);
    }

    private static final class DstNxArpThaCaseImpl
        extends AbstractAugmentable<DstNxArpThaCase>
        implements DstNxArpThaCase {
    
        private final Empty _nxArpTha;
    
        DstNxArpThaCaseImpl(DstNxArpThaCaseBuilder base) {
            super(base.augmentation);
            this._nxArpTha = base.getNxArpTha();
        }
    
        @Override
        public Empty getNxArpTha() {
            return _nxArpTha;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxArpTha);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxArpThaCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            DstNxArpThaCase other = (DstNxArpThaCase)obj;
            if (!Objects.equals(_nxArpTha, other.getNxArpTha())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxArpThaCaseImpl otherImpl = (DstNxArpThaCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxArpThaCase>>, Augmentation<DstNxArpThaCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxArpThaCase");
            CodeHelpers.appendValue(helper, "_nxArpTha", _nxArpTha);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
