package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.group.input.updated.group.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.encap.grouping.NxEncap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionEncapRpcUpdateGroupUpdatedCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionEncapRpcUpdateGroupUpdatedCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionEncapRpcUpdateGroupUpdatedCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionEncapRpcUpdateGroupUpdatedCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionEncapRpcUpdateGroupUpdatedCaseBuilder
 * @see Builder
 *
 */
public class NxActionEncapRpcUpdateGroupUpdatedCaseBuilder implements Builder<NxActionEncapRpcUpdateGroupUpdatedCase> {

    private NxEncap _nxEncap;


    Map<Class<? extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> augmentation = Collections.emptyMap();

    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder() {
    }
    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping arg) {
        this._nxEncap = arg.getNxEncap();
    }

    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder(NxActionEncapRpcUpdateGroupUpdatedCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> aug =((AugmentationHolder<NxActionEncapRpcUpdateGroupUpdatedCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxEncap = base.getNxEncap();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping) {
            this._nxEncap = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping)arg).getNxEncap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping]");
    }

    public NxEncap getNxEncap() {
        return _nxEncap;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder setNxEncap(final NxEncap value) {
        this._nxEncap = value;
        return this;
    }
    
    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> augmentationType, Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionEncapRpcUpdateGroupUpdatedCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionEncapRpcUpdateGroupUpdatedCase build() {
        return new NxActionEncapRpcUpdateGroupUpdatedCaseImpl(this);
    }

    private static final class NxActionEncapRpcUpdateGroupUpdatedCaseImpl
        extends AbstractAugmentable<NxActionEncapRpcUpdateGroupUpdatedCase>
        implements NxActionEncapRpcUpdateGroupUpdatedCase {
    
        private final NxEncap _nxEncap;
    
        NxActionEncapRpcUpdateGroupUpdatedCaseImpl(NxActionEncapRpcUpdateGroupUpdatedCaseBuilder base) {
            super(base.augmentation);
            this._nxEncap = base.getNxEncap();
        }
    
        @Override
        public Class<NxActionEncapRpcUpdateGroupUpdatedCase> getImplementedInterface() {
            return NxActionEncapRpcUpdateGroupUpdatedCase.class;
        }
    
        @Override
        public NxEncap getNxEncap() {
            return _nxEncap;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxEncap);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionEncapRpcUpdateGroupUpdatedCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionEncapRpcUpdateGroupUpdatedCase other = (NxActionEncapRpcUpdateGroupUpdatedCase)obj;
            if (!Objects.equals(_nxEncap, other.getNxEncap())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionEncapRpcUpdateGroupUpdatedCaseImpl otherImpl = (NxActionEncapRpcUpdateGroupUpdatedCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionEncapRpcUpdateGroupUpdatedCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionEncapRpcUpdateGroupUpdatedCase");
            CodeHelpers.appendValue(helper, "_nxEncap", _nxEncap);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
