package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.flow.input.original.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.encap.grouping.NxEncap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder
 * @see Builder
 *
 */
public class NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder implements Builder<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase> {

    private NxEncap _nxEncap;


    Map<Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder() {
    }
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping arg) {
        this._nxEncap = arg.getNxEncap();
    }

    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder(NxActionEncapRpcUpdateFlowOriginalWriteActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> aug =((AugmentationHolder<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxEncap = base.getNxEncap();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping) {
            this._nxEncap = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping)arg).getNxEncap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping]");
    }

    public NxEncap getNxEncap() {
        return _nxEncap;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder setNxEncap(final NxEncap value) {
        this._nxEncap = value;
        return this;
    }
    
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> augmentationType, Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCase build() {
        return new NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl(this);
    }

    private static final class NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl
        extends AbstractAugmentable<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>
        implements NxActionEncapRpcUpdateFlowOriginalWriteActionsCase {
    
        private final NxEncap _nxEncap;
    
        NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl(NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxEncap = base.getNxEncap();
        }
    
        @Override
        public Class<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase> getImplementedInterface() {
            return NxActionEncapRpcUpdateFlowOriginalWriteActionsCase.class;
        }
    
        @Override
        public NxEncap getNxEncap() {
            return _nxEncap;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxEncap);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionEncapRpcUpdateFlowOriginalWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionEncapRpcUpdateFlowOriginalWriteActionsCase other = (NxActionEncapRpcUpdateFlowOriginalWriteActionsCase)obj;
            if (!Objects.equals(_nxEncap, other.getNxEncap())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl otherImpl = (NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionEncapRpcUpdateFlowOriginalWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxEncap", _nxEncap);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
