package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.remove.flow.input.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder
 * @see Builder
 *
 */
public class NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder implements Builder<NxActionMultipathRpcRemoveFlowWriteActionsCase> {

    private NxMultipath _nxMultipath;


    Map<Class<? extends Augmentation<NxActionMultipathRpcRemoveFlowWriteActionsCase>>, Augmentation<NxActionMultipathRpcRemoveFlowWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder() {
    }
    public NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping arg) {
        this._nxMultipath = arg.getNxMultipath();
    }

    public NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder(NxActionMultipathRpcRemoveFlowWriteActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionMultipathRpcRemoveFlowWriteActionsCase>>, Augmentation<NxActionMultipathRpcRemoveFlowWriteActionsCase>> aug =((AugmentationHolder<NxActionMultipathRpcRemoveFlowWriteActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxMultipath = base.getNxMultipath();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping) {
            this._nxMultipath = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping)arg).getNxMultipath();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping]");
    }

    public NxMultipath getNxMultipath() {
        return _nxMultipath;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionMultipathRpcRemoveFlowWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder setNxMultipath(final NxMultipath value) {
        this._nxMultipath = value;
        return this;
    }
    
    public NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionMultipathRpcRemoveFlowWriteActionsCase>> augmentationType, Augmentation<NxActionMultipathRpcRemoveFlowWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionMultipathRpcRemoveFlowWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionMultipathRpcRemoveFlowWriteActionsCase build() {
        return new NxActionMultipathRpcRemoveFlowWriteActionsCaseImpl(this);
    }

    private static final class NxActionMultipathRpcRemoveFlowWriteActionsCaseImpl
        extends AbstractAugmentable<NxActionMultipathRpcRemoveFlowWriteActionsCase>
        implements NxActionMultipathRpcRemoveFlowWriteActionsCase {
    
        private final NxMultipath _nxMultipath;
    
        NxActionMultipathRpcRemoveFlowWriteActionsCaseImpl(NxActionMultipathRpcRemoveFlowWriteActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxMultipath = base.getNxMultipath();
        }
    
        @Override
        public Class<NxActionMultipathRpcRemoveFlowWriteActionsCase> getImplementedInterface() {
            return NxActionMultipathRpcRemoveFlowWriteActionsCase.class;
        }
    
        @Override
        public NxMultipath getNxMultipath() {
            return _nxMultipath;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxMultipath);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionMultipathRpcRemoveFlowWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionMultipathRpcRemoveFlowWriteActionsCase other = (NxActionMultipathRpcRemoveFlowWriteActionsCase)obj;
            if (!Objects.equals(_nxMultipath, other.getNxMultipath())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionMultipathRpcRemoveFlowWriteActionsCaseImpl otherImpl = (NxActionMultipathRpcRemoveFlowWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionMultipathRpcRemoveFlowWriteActionsCase>>, Augmentation<NxActionMultipathRpcRemoveFlowWriteActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionMultipathRpcRemoveFlowWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxMultipath", _nxMultipath);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
