package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstOfMplsLabelCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DstOfMplsLabelCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new DstOfMplsLabelCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DstOfMplsLabelCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DstOfMplsLabelCaseBuilder
 * @see Builder
 *
 */
public class DstOfMplsLabelCaseBuilder implements Builder<DstOfMplsLabelCase> {

    private Boolean _ofMplsLabel;


    Map<Class<? extends Augmentation<DstOfMplsLabelCase>>, Augmentation<DstOfMplsLabelCase>> augmentation = Collections.emptyMap();

    public DstOfMplsLabelCaseBuilder() {
    }
    public DstOfMplsLabelCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping arg) {
        this._ofMplsLabel = arg.isOfMplsLabel();
    }

    public DstOfMplsLabelCaseBuilder(DstOfMplsLabelCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstOfMplsLabelCase>>, Augmentation<DstOfMplsLabelCase>> aug =((AugmentationHolder<DstOfMplsLabelCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ofMplsLabel = base.isOfMplsLabel();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping) {
            this._ofMplsLabel = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping)arg).isOfMplsLabel();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping]");
    }

    public Boolean isOfMplsLabel() {
        return _ofMplsLabel;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstOfMplsLabelCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstOfMplsLabelCaseBuilder setOfMplsLabel(final Boolean value) {
        this._ofMplsLabel = value;
        return this;
    }
    
    public DstOfMplsLabelCaseBuilder addAugmentation(Class<? extends Augmentation<DstOfMplsLabelCase>> augmentationType, Augmentation<DstOfMplsLabelCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstOfMplsLabelCaseBuilder removeAugmentation(Class<? extends Augmentation<DstOfMplsLabelCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstOfMplsLabelCase build() {
        return new DstOfMplsLabelCaseImpl(this);
    }

    private static final class DstOfMplsLabelCaseImpl
        extends AbstractAugmentable<DstOfMplsLabelCase>
        implements DstOfMplsLabelCase {
    
        private final Boolean _ofMplsLabel;
    
        DstOfMplsLabelCaseImpl(DstOfMplsLabelCaseBuilder base) {
            super(base.augmentation);
            this._ofMplsLabel = base.isOfMplsLabel();
        }
    
        @Override
        public Class<DstOfMplsLabelCase> getImplementedInterface() {
            return DstOfMplsLabelCase.class;
        }
    
        @Override
        public Boolean isOfMplsLabel() {
            return _ofMplsLabel;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofMplsLabel);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstOfMplsLabelCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstOfMplsLabelCase other = (DstOfMplsLabelCase)obj;
            if (!Objects.equals(_ofMplsLabel, other.isOfMplsLabel())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstOfMplsLabelCaseImpl otherImpl = (DstOfMplsLabelCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstOfMplsLabelCase>>, Augmentation<DstOfMplsLabelCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstOfMplsLabelCase");
            CodeHelpers.appendValue(helper, "_ofMplsLabel", _ofMplsLabel);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
