package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.zone.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxCtZoneBuilder} instances.
 *
 * @see NxmNxCtZoneBuilder
 *
 */
public class NxmNxCtZoneBuilder implements Builder<NxmNxCtZone> {

    private Integer _ctZone;


    Map<Class<? extends Augmentation<NxmNxCtZone>>, Augmentation<NxmNxCtZone>> augmentation = Collections.emptyMap();

    public NxmNxCtZoneBuilder() {
    }

    public NxmNxCtZoneBuilder(NxmNxCtZone base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxCtZone>>, Augmentation<NxmNxCtZone>> aug =((AugmentationHolder<NxmNxCtZone>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ctZone = base.getCtZone();
    }


    public Integer getCtZone() {
        return _ctZone;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxCtZone>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkCtZoneRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public NxmNxCtZoneBuilder setCtZone(final Integer value) {
    if (value != null) {
        checkCtZoneRange(value);
        
    }
        this._ctZone = value;
        return this;
    }
    
    public NxmNxCtZoneBuilder addAugmentation(Class<? extends Augmentation<NxmNxCtZone>> augmentationType, Augmentation<NxmNxCtZone> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxCtZoneBuilder removeAugmentation(Class<? extends Augmentation<NxmNxCtZone>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxCtZone build() {
        return new NxmNxCtZoneImpl(this);
    }

    private static final class NxmNxCtZoneImpl
        extends AbstractAugmentable<NxmNxCtZone>
        implements NxmNxCtZone {
    
        private final Integer _ctZone;
    
        NxmNxCtZoneImpl(NxmNxCtZoneBuilder base) {
            super(base.augmentation);
            this._ctZone = base.getCtZone();
        }
    
        @Override
        public Class<NxmNxCtZone> getImplementedInterface() {
            return NxmNxCtZone.class;
        }
    
        @Override
        public Integer getCtZone() {
            return _ctZone;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ctZone);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxCtZone.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxCtZone other = (NxmNxCtZone)obj;
            if (!Objects.equals(_ctZone, other.getCtZone())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxCtZoneImpl otherImpl = (NxmNxCtZoneImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxCtZone>>, Augmentation<NxmNxCtZone>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxCtZone");
            CodeHelpers.appendValue(helper, "_ctZone", _ctZone);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
