package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.transmit.packet.input.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearn;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionLearnRpcTransmitPacketCaseBuilder} instances.
 *
 * @see NxActionLearnRpcTransmitPacketCaseBuilder
 *
 */
public class NxActionLearnRpcTransmitPacketCaseBuilder implements Builder<NxActionLearnRpcTransmitPacketCase> {

    private NxLearn _nxLearn;


    Map<Class<? extends Augmentation<NxActionLearnRpcTransmitPacketCase>>, Augmentation<NxActionLearnRpcTransmitPacketCase>> augmentation = Collections.emptyMap();

    public NxActionLearnRpcTransmitPacketCaseBuilder() {
    }
    public NxActionLearnRpcTransmitPacketCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping arg) {
        this._nxLearn = arg.getNxLearn();
    }

    public NxActionLearnRpcTransmitPacketCaseBuilder(NxActionLearnRpcTransmitPacketCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionLearnRpcTransmitPacketCase>>, Augmentation<NxActionLearnRpcTransmitPacketCase>> aug =((AugmentationHolder<NxActionLearnRpcTransmitPacketCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxLearn = base.getNxLearn();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping) {
            this._nxLearn = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping)arg).getNxLearn();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping]");
    }

    public NxLearn getNxLearn() {
        return _nxLearn;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionLearnRpcTransmitPacketCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionLearnRpcTransmitPacketCaseBuilder setNxLearn(final NxLearn value) {
        this._nxLearn = value;
        return this;
    }
    
    public NxActionLearnRpcTransmitPacketCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionLearnRpcTransmitPacketCase>> augmentationType, Augmentation<NxActionLearnRpcTransmitPacketCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionLearnRpcTransmitPacketCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionLearnRpcTransmitPacketCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionLearnRpcTransmitPacketCase build() {
        return new NxActionLearnRpcTransmitPacketCaseImpl(this);
    }

    private static final class NxActionLearnRpcTransmitPacketCaseImpl
        extends AbstractAugmentable<NxActionLearnRpcTransmitPacketCase>
        implements NxActionLearnRpcTransmitPacketCase {
    
        private final NxLearn _nxLearn;
    
        NxActionLearnRpcTransmitPacketCaseImpl(NxActionLearnRpcTransmitPacketCaseBuilder base) {
            super(base.augmentation);
            this._nxLearn = base.getNxLearn();
        }
    
        @Override
        public Class<NxActionLearnRpcTransmitPacketCase> getImplementedInterface() {
            return NxActionLearnRpcTransmitPacketCase.class;
        }
    
        @Override
        public NxLearn getNxLearn() {
            return _nxLearn;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxLearn);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionLearnRpcTransmitPacketCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionLearnRpcTransmitPacketCase other = (NxActionLearnRpcTransmitPacketCase)obj;
            if (!Objects.equals(_nxLearn, other.getNxLearn())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionLearnRpcTransmitPacketCaseImpl otherImpl = (NxActionLearnRpcTransmitPacketCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionLearnRpcTransmitPacketCase>>, Augmentation<NxActionLearnRpcTransmitPacketCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionLearnRpcTransmitPacketCase");
            CodeHelpers.appendValue(helper, "_nxLearn", _nxLearn);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
