package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.ct.mark._case;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionCtMarkBuilder} instances.
 *
 * @see NxActionCtMarkBuilder
 *
 */
public class NxActionCtMarkBuilder implements Builder<NxActionCtMark> {

    private Long _ctMark;


    Map<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>> augmentation = Collections.emptyMap();

    public NxActionCtMarkBuilder() {
    }

    public NxActionCtMarkBuilder(NxActionCtMark base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>> aug =((AugmentationHolder<NxActionCtMark>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ctMark = base.getCtMark();
    }


    public Long getCtMark() {
        return _ctMark;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionCtMark>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkCtMarkRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public NxActionCtMarkBuilder setCtMark(final Long value) {
    if (value != null) {
        checkCtMarkRange(value);
        
    }
        this._ctMark = value;
        return this;
    }
    
    public NxActionCtMarkBuilder addAugmentation(Class<? extends Augmentation<NxActionCtMark>> augmentationType, Augmentation<NxActionCtMark> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionCtMarkBuilder removeAugmentation(Class<? extends Augmentation<NxActionCtMark>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionCtMark build() {
        return new NxActionCtMarkImpl(this);
    }

    private static final class NxActionCtMarkImpl
        extends AbstractAugmentable<NxActionCtMark>
        implements NxActionCtMark {
    
        private final Long _ctMark;
    
        NxActionCtMarkImpl(NxActionCtMarkBuilder base) {
            super(base.augmentation);
            this._ctMark = base.getCtMark();
        }
    
        @Override
        public Class<NxActionCtMark> getImplementedInterface() {
            return NxActionCtMark.class;
        }
    
        @Override
        public Long getCtMark() {
            return _ctMark;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ctMark);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionCtMark.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionCtMark other = (NxActionCtMark)obj;
            if (!Objects.equals(_ctMark, other.getCtMark())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionCtMarkImpl otherImpl = (NxActionCtMarkImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionCtMark");
            CodeHelpers.appendValue(helper, "_ctMark", _ctMark);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
