package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.NxActionFinTimeout;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseBuilder} instances.
 *
 * @see NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseBuilder
 *
 */
public class NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseBuilder implements Builder<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase> {

    private NxActionFinTimeout _nxActionFinTimeout;


    Map<Class<? extends Augmentation<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseBuilder() {
    }
    public NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping arg) {
        this._nxActionFinTimeout = arg.getNxActionFinTimeout();
    }

    public NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseBuilder(NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase>> aug =((AugmentationHolder<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxActionFinTimeout = base.getNxActionFinTimeout();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping) {
            this._nxActionFinTimeout = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping)arg).getNxActionFinTimeout();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping]");
    }

    public NxActionFinTimeout getNxActionFinTimeout() {
        return _nxActionFinTimeout;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseBuilder setNxActionFinTimeout(final NxActionFinTimeout value) {
        this._nxActionFinTimeout = value;
        return this;
    }
    
    public NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase>> augmentationType, Augmentation<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase build() {
        return new NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseImpl(this);
    }

    private static final class NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseImpl
        extends AbstractAugmentable<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase>
        implements NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase {
    
        private final NxActionFinTimeout _nxActionFinTimeout;
    
        NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseImpl(NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxActionFinTimeout = base.getNxActionFinTimeout();
        }
    
        @Override
        public Class<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase> getImplementedInterface() {
            return NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase.class;
        }
    
        @Override
        public NxActionFinTimeout getNxActionFinTimeout() {
            return _nxActionFinTimeout;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxActionFinTimeout);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase other = (NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase)obj;
            if (!Objects.equals(_nxActionFinTimeout, other.getNxActionFinTimeout())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseImpl otherImpl = (NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionFinTimeoutNotifFlowsStatisticsUpdateApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxActionFinTimeout", _nxActionFinTimeout);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
