package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstNxTunIdCaseBuilder} instances.
 *
 * @see DstNxTunIdCaseBuilder
 *
 */
public class DstNxTunIdCaseBuilder implements Builder<DstNxTunIdCase> {

    private Boolean _nxTunId;


    Map<Class<? extends Augmentation<DstNxTunIdCase>>, Augmentation<DstNxTunIdCase>> augmentation = Collections.emptyMap();

    public DstNxTunIdCaseBuilder() {
    }
    public DstNxTunIdCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIdGrouping arg) {
        this._nxTunId = arg.isNxTunId();
    }

    public DstNxTunIdCaseBuilder(DstNxTunIdCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxTunIdCase>>, Augmentation<DstNxTunIdCase>> aug =((AugmentationHolder<DstNxTunIdCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxTunId = base.isNxTunId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIdGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIdGrouping) {
            this._nxTunId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIdGrouping)arg).isNxTunId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIdGrouping]");
    }

    public Boolean isNxTunId() {
        return _nxTunId;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxTunIdCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxTunIdCaseBuilder setNxTunId(final Boolean value) {
        this._nxTunId = value;
        return this;
    }
    
    public DstNxTunIdCaseBuilder addAugmentation(Class<? extends Augmentation<DstNxTunIdCase>> augmentationType, Augmentation<DstNxTunIdCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxTunIdCaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxTunIdCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxTunIdCase build() {
        return new DstNxTunIdCaseImpl(this);
    }

    private static final class DstNxTunIdCaseImpl
        extends AbstractAugmentable<DstNxTunIdCase>
        implements DstNxTunIdCase {
    
        private final Boolean _nxTunId;
    
        DstNxTunIdCaseImpl(DstNxTunIdCaseBuilder base) {
            super(base.augmentation);
            this._nxTunId = base.isNxTunId();
        }
    
        @Override
        public Class<DstNxTunIdCase> getImplementedInterface() {
            return DstNxTunIdCase.class;
        }
    
        @Override
        public Boolean isNxTunId() {
            return _nxTunId;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxTunId);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxTunIdCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstNxTunIdCase other = (DstNxTunIdCase)obj;
            if (!Objects.equals(_nxTunId, other.isNxTunId())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxTunIdCaseImpl otherImpl = (DstNxTunIdCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxTunIdCase>>, Augmentation<DstNxTunIdCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxTunIdCase");
            CodeHelpers.appendValue(helper, "_nxTunId", _nxTunId);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
