/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.Dst;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxMultipathBuilder
implements Builder<NxMultipath> {
    private OfjNxMpAlgorithm _algorithm;
    private Long _arg;
    private Integer _basis;
    private Dst _dst;
    private OfjNxHashFields _fields;
    private Integer _maxLink;
    Map<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>> augmentation = Collections.emptyMap();

    public NxMultipathBuilder() {
    }

    public NxMultipathBuilder(NxMultipath base) {
        Map aug;
        this._algorithm = base.getAlgorithm();
        this._arg = base.getArg();
        this._basis = base.getBasis();
        this._dst = base.getDst();
        this._fields = base.getFields();
        this._maxLink = base.getMaxLink();
        if (base instanceof NxMultipathImpl) {
            NxMultipathImpl impl = (NxMultipathImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>>(aug);
        }
    }

    public OfjNxMpAlgorithm getAlgorithm() {
        return this._algorithm;
    }

    public Long getArg() {
        return this._arg;
    }

    public Integer getBasis() {
        return this._basis;
    }

    public Dst getDst() {
        return this._dst;
    }

    public OfjNxHashFields getFields() {
        return this._fields;
    }

    public Integer getMaxLink() {
        return this._maxLink;
    }

    public <E$$ extends Augmentation<NxMultipath>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NxMultipathBuilder setAlgorithm(OfjNxMpAlgorithm value) {
        this._algorithm = value;
        return this;
    }

    private static void checkArgRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public NxMultipathBuilder setArg(Long value) {
        if (value != null) {
            NxMultipathBuilder.checkArgRange(value);
        }
        this._arg = value;
        return this;
    }

    private static void checkBasisRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public NxMultipathBuilder setBasis(Integer value) {
        if (value != null) {
            NxMultipathBuilder.checkBasisRange(value);
        }
        this._basis = value;
        return this;
    }

    public NxMultipathBuilder setDst(Dst value) {
        this._dst = value;
        return this;
    }

    public NxMultipathBuilder setFields(OfjNxHashFields value) {
        this._fields = value;
        return this;
    }

    private static void checkMaxLinkRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public NxMultipathBuilder setMaxLink(Integer value) {
        if (value != null) {
            NxMultipathBuilder.checkMaxLinkRange(value);
        }
        this._maxLink = value;
        return this;
    }

    public NxMultipathBuilder addAugmentation(Class<? extends Augmentation<NxMultipath>> augmentationType, Augmentation<NxMultipath> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxMultipathBuilder removeAugmentation(Class<? extends Augmentation<NxMultipath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxMultipath build() {
        return new NxMultipathImpl(this);
    }

    private static final class NxMultipathImpl
    implements NxMultipath {
        private final OfjNxMpAlgorithm _algorithm;
        private final Long _arg;
        private final Integer _basis;
        private final Dst _dst;
        private final OfjNxHashFields _fields;
        private final Integer _maxLink;
        private Map<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxMultipathImpl(NxMultipathBuilder base) {
            this._algorithm = base.getAlgorithm();
            this._arg = base.getArg();
            this._basis = base.getBasis();
            this._dst = base.getDst();
            this._fields = base.getFields();
            this._maxLink = base.getMaxLink();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NxMultipath> getImplementedInterface() {
            return NxMultipath.class;
        }

        @Override
        public OfjNxMpAlgorithm getAlgorithm() {
            return this._algorithm;
        }

        @Override
        public Long getArg() {
            return this._arg;
        }

        @Override
        public Integer getBasis() {
            return this._basis;
        }

        @Override
        public Dst getDst() {
            return this._dst;
        }

        @Override
        public OfjNxHashFields getFields() {
            return this._fields;
        }

        @Override
        public Integer getMaxLink() {
            return this._maxLink;
        }

        public <E$$ extends Augmentation<NxMultipath>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._algorithm);
            result = 31 * result + Objects.hashCode(this._arg);
            result = 31 * result + Objects.hashCode(this._basis);
            result = 31 * result + Objects.hashCode(this._dst);
            result = 31 * result + Objects.hashCode(this._fields);
            result = 31 * result + Objects.hashCode(this._maxLink);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxMultipath.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxMultipath other = (NxMultipath)obj;
            if (!Objects.equals(this._algorithm, other.getAlgorithm())) {
                return false;
            }
            if (!Objects.equals(this._arg, other.getArg())) {
                return false;
            }
            if (!Objects.equals(this._basis, other.getBasis())) {
                return false;
            }
            if (!Objects.equals(this._dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(this._fields, other.getFields())) {
                return false;
            }
            if (!Objects.equals(this._maxLink, other.getMaxLink())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxMultipathImpl otherImpl = (NxMultipathImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxMultipath");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_algorithm", (Object)this._algorithm);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_arg", (Object)this._arg);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_basis", (Object)this._basis);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dst", (Object)this._dst);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_fields", (Object)this._fields);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxLink", (Object)this._maxLink);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

