package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcOfEthTypeCaseBuilder} instances.
 *
 * @see SrcOfEthTypeCaseBuilder
 *
 */
public class SrcOfEthTypeCaseBuilder implements Builder<SrcOfEthTypeCase> {

    private Boolean _ofEthType;


    Map<Class<? extends Augmentation<SrcOfEthTypeCase>>, Augmentation<SrcOfEthTypeCase>> augmentation = Collections.emptyMap();

    public SrcOfEthTypeCaseBuilder() {
    }
    public SrcOfEthTypeCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthTypeGrouping arg) {
        this._ofEthType = arg.isOfEthType();
    }

    public SrcOfEthTypeCaseBuilder(SrcOfEthTypeCase base) {
        this._ofEthType = base.isOfEthType();
        if (base instanceof SrcOfEthTypeCaseImpl) {
            SrcOfEthTypeCaseImpl impl = (SrcOfEthTypeCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcOfEthTypeCase>>, Augmentation<SrcOfEthTypeCase>> aug =((AugmentationHolder<SrcOfEthTypeCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthTypeGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthTypeGrouping) {
            this._ofEthType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthTypeGrouping)arg).isOfEthType();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfEthTypeGrouping]");
    }

    public Boolean isOfEthType() {
        return _ofEthType;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcOfEthTypeCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcOfEthTypeCaseBuilder setOfEthType(final Boolean value) {
        this._ofEthType = value;
        return this;
    }
    
    public SrcOfEthTypeCaseBuilder addAugmentation(Class<? extends Augmentation<SrcOfEthTypeCase>> augmentationType, Augmentation<SrcOfEthTypeCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcOfEthTypeCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcOfEthTypeCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcOfEthTypeCase build() {
        return new SrcOfEthTypeCaseImpl(this);
    }

    private static final class SrcOfEthTypeCaseImpl implements SrcOfEthTypeCase {
    
        private final Boolean _ofEthType;
    
        private Map<Class<? extends Augmentation<SrcOfEthTypeCase>>, Augmentation<SrcOfEthTypeCase>> augmentation = Collections.emptyMap();
    
        SrcOfEthTypeCaseImpl(SrcOfEthTypeCaseBuilder base) {
            this._ofEthType = base.isOfEthType();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcOfEthTypeCase> getImplementedInterface() {
            return SrcOfEthTypeCase.class;
        }
    
        @Override
        public Boolean isOfEthType() {
            return _ofEthType;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<SrcOfEthTypeCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofEthType);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcOfEthTypeCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcOfEthTypeCase other = (SrcOfEthTypeCase)obj;
            if (!Objects.equals(_ofEthType, other.isOfEthType())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcOfEthTypeCaseImpl otherImpl = (SrcOfEthTypeCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcOfEthTypeCase>>, Augmentation<SrcOfEthTypeCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcOfEthTypeCase");
            CodeHelpers.appendValue(helper, "_ofEthType", _ofEthType);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
